<div class="modal fade" id="editChecklist<?php echo e($checklist->id); ?>" tabindex="-1"
     aria-labelledby="editChecklistLabel<?php echo e($checklist->id); ?>" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content border-0 rounded-3 shadow">
            <div class="modal-header py-3 px-4">
                <h6 class="modal-title fw-semibold" id="editChecklistLabel<?php echo e($checklist->id); ?>">Edit Checklist</h6>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body pt-0 px-4 pb-4">
                <form action="<?php echo e(route('checklist.edit', $checklist->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <div class="mb-3">
                        <label for="title_<?php echo e($checklist->id); ?>" class="form-label small text-muted">Judul Checklist</label>
                        <input type="text" id="title_<?php echo e($checklist->id); ?>" name="title"
                               class="form-control form-control-lg"
                               value="<?php echo e(old('title', $checklist->title)); ?>"
                               required
                               autocomplete="off"
                               style="font-size: 16px;">
                    </div>

                    <div class="mb-3">
                        <label for="hotel_<?php echo e($checklist->id); ?>" class="form-label small text-muted">Hotel</label>
                        <select id="hotel_<?php echo e($checklist->id); ?>" name="hotel" class="form-select form-select-lg" style="font-size: 16px;">
                            <option value="HARRIS" <?php echo e($checklist->hotel == 'HARRIS' ? 'selected' : ''); ?>>HARRIS</option>
                            <option value="POP" <?php echo e($checklist->hotel == 'POP' ? 'selected' : ''); ?>>POP</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="mod_type_<?php echo e($checklist->id); ?>" class="form-label small text-muted">Kategori</label>
                        <select id="mod_type_<?php echo e($checklist->id); ?>" name="mod_type" 
                                class="form-select form-select-lg" 
                                disabled 
                                style="font-size: 16px; background-color: #f8f9fa;">
                            <option value="general" <?php echo e($checklist->mod_type == 'general' ? 'selected' : ''); ?>>General</option>
                            <option value="room_inspection" <?php echo e($checklist->mod_type == 'room_inspection' ? 'selected' : ''); ?>>Room Inspection</option>
                        </select>
                        <input type="hidden" name="mod_type" value="<?php echo e($checklist->mod_type); ?>">
                    </div>

                    <div class="d-grid gap-2 mt-3">
                        <button type="submit" class="btn btn-primary btn-lg rounded-pill py-3">
                            <i class="fas fa-save me-2"></i>Simpan Perubahan
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div><?php /**PATH C:\#PKL PROJECT\pklproject\resources\views/admin/manajemen/modal/checklist_edit.blade.php ENDPATH**/ ?>