<?php
$hideMobileHeader = true;
?>



<?php $__env->startSection('content'); ?>

<div class="d-none d-lg-block">
    <?php if(session('modal_success')): ?>
    <div class="position-fixed top-0 start-50 translate-middle-x mt-3 z-3" style="z-index: 1055;">
        <div class="alert alert-success alert-dismissible fade show mb-0 rounded-pill px-4 py-2 shadow-sm" role="alert">
            <?php if(session('modal_success') == 'username'): ?> Username berhasil diperbarui.
            <?php elseif(session('modal_success') == 'password'): ?> Password berhasil diperbarui.
            <?php elseif(session('modal_success') == 'email'): ?> Email berhasil diperbarui.
            <?php endif; ?>
            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    </div>
    <?php endif; ?>

    <style>
    .content-area.settings-page {
        max-height: none;
        overflow-y: visible;
        padding: 24px;
    }

    .settings-item {
        transition: all 0.2s ease;
    }

    .settings-item:hover {
        background: var(--gray-100);
        transform: translateX(4px);
    }

    .profile-card {
        background: linear-gradient(135deg, var(--navy), var(--navy-medium));
        color: white;
    }

    .avatar-circle {
        width: 90px;
        height: 90px;
        border-radius: 50%;
        background: white;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 36px;
        font-weight: bold;
        color: #222;
        box-shadow: 0 4px 15px rgba(0, 0, 0, .15);
    }

    .modal-form .form-label {
        font-weight: 600;
    }
    </style>

    <div class="container-fluid">
        <div class="row g-4">
            <!-- LEFT: PROFILE -->
            <div class="col-12 col-lg-4">
                <div class="card border-0 shadow-sm rounded-4 profile-card h-100">
                    <div class="card-body text-center py-4">
                        <div class="avatar-circle mx-auto mb-3">
                            <?php echo e(strtoupper(substr(Auth::user()->name ?? 'U', 0, 1))); ?>

                        </div>
                        <h5 class="fw-bold mb-1"><?php echo e(Auth::user()->name ?? 'User'); ?></h5>
                        <div class="opacity-75 small"><?php echo e(optional(Auth::user())->email); ?></div>
                        <?php if(optional(Auth::user())->role): ?>
                        <div class="opacity-75 small mt-1"><?php echo e(Auth::user()->role->name); ?></div>
                        <?php endif; ?>
                        <hr class="border-white opacity-25 my-4">
                        <div class="small opacity-75">
                            Kelola informasi akun dan keamanan Anda di sini.
                        </div>
                    </div>
                </div>
            </div>

            <!-- RIGHT: MENU -->
            <div class="col-12 col-lg-8">
                <div class="card border-0 shadow-sm rounded-4">
                    <div class="card-header bg-white py-3">
                        <h5 class="mb-0 fw-bold">
                            <i class="fas fa-user-cog me-2 text-primary"></i>
                            Pengaturan Akun
                        </h5>
                    </div>

                    <div class="list-group list-group-flush">
                        <a href="#"
                            class="list-group-item list-group-item-action d-flex justify-content-between align-items-center py-3 settings-item"
                            data-bs-toggle="modal" data-bs-target="#modalUsername">
                            <span><i class="fas fa-user me-3 text-primary"></i> Username</span>
                            <span class="text-muted me-3" id="display-username"><?php echo e(Auth::user()->name ?? '-'); ?></span>
                            <i class="fas fa-chevron-right text-muted"></i>
                        </a>

                        <a href="#"
                            class="list-group-item list-group-item-action d-flex justify-content-between align-items-center py-3 settings-item"
                            data-bs-toggle="modal" data-bs-target="#modalPassword">
                            <span><i class="fas fa-lock me-3 text-primary"></i> Password</span>
                            <i class="fas fa-chevron-right text-muted"></i>
                        </a>

                        <a href="#"
                            class="list-group-item list-group-item-action d-flex justify-content-between align-items-center py-3 settings-item"
                            data-bs-toggle="modal" data-bs-target="#modalEmail">
                            <span><i class="fas fa-envelope me-3 text-primary"></i> Email Address</span>
                            <span class="text-muted me-3" id="display-email"><?php echo e(Auth::user()->email); ?></span>
                            <i class="fas fa-chevron-right text-muted"></i>
                        </a>

                        <a href="#" onclick="confirmLogout(event, '<?php echo e(route('logout')); ?>')"
                            class="list-group-item list-group-item-action d-flex justify-content-between align-items-center py-3 text-danger settings-item">
                            <span><i class="fas fa-sign-out-alt me-3"></i> Sign Out</span>
                            <i class="fas fa-chevron-right"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('mobile-content'); ?>
<style>
/* ===== iOS Premium Interactive ===== */
.ios-bg {
    background: #f2f2f7;
    min-height: 100vh;
    padding-bottom: 30px;
}

/* Header */
.ios-header {
    background: linear-gradient(135deg, #f8fafc, #eef2f7);
    padding: 1px 20px 45px;
    text-align: center;
}

/* Avatar */
.ios-avatar {
    width: 82px;
    height: 82px;
    border-radius: 50%;
    background: #ffffff;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 36px;
    font-weight: 700;
    color: #111;
    margin: 0 auto 10px;
    box-shadow: 0 8px 22px rgba(0, 0, 0, .12);
    animation: breathe 4s ease-in-out infinite;
}

@keyframes breathe {

    0%,
    100% {
        transform: scale(1);
    }

    50% {
        transform: scale(1.04);
    }
}

.ios-name {
    font-size: 17px;
    font-weight: 600;
}

.ios-email {
    font-size: 13px;
    color: #6b7280;
}

/* Floating Card */
.ios-sheet {
    margin: -46px 14px 0;
    background: #ffffff;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 12px 30px rgba(0, 0, 0, .12);
}

/* Item */
.ios-item {
    padding: 18px 18px;
    font-size: 16px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    animation: slideUp .45s ease both;
    transition: all .15s ease;
}

.ios-item:nth-child(1) {
    animation-delay: .05s
}

.ios-item:nth-child(2) {
    animation-delay: .10s
}

.ios-item:nth-child(3) {
    animation-delay: .15s
}

.ios-item:nth-child(4) {
    animation-delay: .20s
}

@keyframes slideUp {
    from {
        transform: translateY(20px);
        opacity: 0
    }

    to {
        transform: translateY(0);
        opacity: 1
    }
}

.ios-item:active {
    transform: scale(0.97);
    background: #f2f2f7;
}

/* Icon badge */
.ios-icon-badge {
    width: 34px;
    height: 34px;
    border-radius: 10px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    margin-right: 14px;
    font-size: 15px;
    color: white;
}

.bg-user {
    background: #3b82f6;
}

.bg-lock {
    background: #6366f1;
}

.bg-mail {
    background: #10b981;
}

.bg-logout {
    background: #ef4444;
}

.ios-row-left {
    display: flex;
    align-items: center;
    overflow: hidden;
}

.ios-value {
    color: #6b7280;
    font-size: 14px;
    margin-left: auto;
    max-width: 180px;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}

/* Mobile Modal Styling - FIXED */
@media (max-width: 991.98px) {
    body {
        overflow: hidden;
        height: 100vh;
        position: fixed;
        width: 100%;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
    }

    .modal {
        --bs-modal-zindex: 1055;
        --bs-modal-width: 100%;
        --bs-modal-padding: 0;
        --bs-modal-margin: 0;
        --bs-modal-bg: transparent;
    }

    .modal-dialog {
        margin: 0;
        margin-top: auto;
        margin-bottom: 0;
        max-width: 100%;
        width: 100%;
        max-height: 83vh;
        display: flex;
        align-items: flex-end;
        min-height: 93vh;
        pointer-events: none;
    }

    .modal-content {
        border-radius: 24px 24px 0 0;
        border: none;
        box-shadow: 0 -10px 40px rgba(0, 0, 0, 0.2);
        pointer-events: auto;
        max-height: 100vh;
        overflow-y: auto;
    }

    .modal-header {
        border: none;
        padding: 20px 24px 16px;
        position: relative;
        background: #fff;
        border-bottom: 1px solid #f0f0f0;
    }

    .modal-title {
        font-size: 18px;
        font-weight: 600;
        width: 100%;
        text-align: center;
        color: #111827;
        margin: 0;
    }

    .modal-header .btn-close {
        position: absolute;
        right: 20px;
        top: 20px;
        z-index: 1;
        background-size: 14px;
        opacity: 0.7;
        padding: 8px;
        margin: 0;
    }

    .modal-body {
        padding: 20px 24px;
        background: #fff;
    }

    .modal-footer {
        border: none;
        padding: 20px 24px;
        background: #fff;
        display: flex;
        gap: 12px;
        border-top: 1px solid #f0f0f0;
    }

    .modal-footer .btn {
        flex: 1;
        padding: 14px;
        font-size: 16px;
        font-weight: 500;
        border-radius: 14px;
        border: none;
    }

    .modal-footer .btn-outline-secondary {
        background: #f3f4f6;
        color: #374151;
        border: 1px solid #d1d5db;
    }

    .modal-footer .btn-primary {
        background: #3b82f6;
        color: white;
    }

    .form-label {
        font-size: 15px;
        font-weight: 600;
        margin-bottom: 8px;
        color: #374151;
        display: block;
    }

    .form-control {
        font-size: 16px;
        padding: 14px 16px;
        border-radius: 12px;
        border: 1px solid #d1d5db;
        background: #fff;
        width: 100%;
        box-sizing: border-box;
    }

    .form-control:focus {
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
        outline: none;
    }

    .text-danger.small {
        font-size: 13px;
        margin-top: 6px;
        display: block;
    }

    /* Modal backdrop */
    .modal-backdrop {
        background-color: rgba(0, 0, 0, 0.5);
    }

    .modal.show .modal-dialog {
        transform: translateY(0);
    }

    /* Input field styling */
    .mb-3 {
        margin-bottom: 20px !important;
    }

    /* Modal animation */
    @keyframes slideUpModal {
        from {
            transform: translateY(100%);
        }

        to {
            transform: translateY(0);
        }
    }

    .modal.fade .modal-dialog {
        transform: translateY(100%);
        transition: transform 0.3s ease-out;
    }

    .modal.show .modal-dialog {
        transform: translateY(0);
        animation: slideUpModal 0.3s ease-out;
    }
}
</style>

<div class="ios-bg">
    <!-- HEADER -->
    <div class="ios-header">
        <div class="ios-avatar">
            <?php echo e(strtoupper(substr(Auth::user()->name ?? 'U', 0, 1))); ?>

        </div>
        <div class="ios-name"><?php echo e(Auth::user()->name ?? 'User'); ?></div>
        <div class="ios-email"><?php echo e(optional(Auth::user())->email); ?></div>
        <?php if(optional(Auth::user())->role): ?>
        <div class="ios-email mt-1"><?php echo e(Auth::user()->role->name); ?></div>
        <?php endif; ?>
    </div>

    <!-- FLOATING SHEET -->
    <div class="ios-sheet">
        <a href="#" class="ios-item text-decoration-none text-dark border-bottom" data-bs-toggle="modal"
            data-bs-target="#modalUsername">
            <div class="ios-row-left">
                <div class="ios-icon-badge bg-user"><i class="fas fa-user"></i></div>
                <span>Nama Lengkap</span>
            </div>
            <span class="ios-value" id="mobile-display-username"><?php echo e(Auth::user()->name ?? '-'); ?></span>
        </a>

        <a href="#" class="ios-item text-decoration-none text-dark border-bottom" data-bs-toggle="modal"
            data-bs-target="#modalPassword">
            <div class="ios-row-left">
                <div class="ios-icon-badge bg-lock"><i class="fas fa-lock"></i></div>
                <span>Kata Sandi</span>
            </div>
        </a>

        <a href="#" class="ios-item text-decoration-none text-dark border-bottom" data-bs-toggle="modal"
            data-bs-target="#modalEmail">
            <div class="ios-row-left">
                <div class="ios-icon-badge bg-mail"><i class="fas fa-envelope"></i></div>
                <span>Alamat Email</span>
            </div>
            <span class="ios-value" id="mobile-display-email"><?php echo e(Auth::user()->email); ?></span>
        </a>

        <a href="#" onclick="confirmLogout(event, '<?php echo e(route('logout')); ?>')"
            class="ios-item text-decoration-none text-danger">
            <div class="ios-row-left">
                <div class="ios-icon-badge bg-logout"><i class="fas fa-sign-out-alt"></i></div>
                <span>Keluar</span>
            </div>
        </a>
    </div>
</div>
<?php $__env->stopSection(); ?>

<!-- MODAL UNTUK SEMUA DEVICE (DESKTOP & MOBILE) -->
<div class="modal fade" id="modalUsername" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="fas fa-user me-2 text-primary"></i>Ubah Username</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('settings.update.username')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="name" class="form-label">Username Baru</label>
                        <input type="text" class="form-control" id="name" name="name"
                            value="<?php echo e(old('name', Auth::user()->name)); ?>" data-original-value="<?php echo e(Auth::user()->name); ?>"
                            required maxlength="50">
                        <?php $__errorArgs = ['name', 'name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modalPassword" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="fas fa-lock me-2 text-primary"></i>Ubah Password</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('settings.update.password')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="current_password" class="form-label">Password Lama</label>
                        <input type="password" class="form-control" id="current_password" name="current_password"
                            required>
                        <?php $__errorArgs = ['current_password', 'password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="mb-3">
                        <label for="password" class="form-label">Password Baru</label>
                        <input type="password" class="form-control" id="password" name="password" required
                            minlength="8">
                        <?php $__errorArgs = ['password', 'password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="mb-3">
                        <label for="password_confirmation" class="form-label">Konfirmasi Password Baru</label>
                        <input type="password" class="form-control" id="password_confirmation"
                            name="password_confirmation" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modalEmail" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="fas fa-envelope me-2 text-primary"></i>Ubah Email</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('settings.update.email')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="email" class="form-label">Email Baru</label>
                        <input type="email" class="form-control" id="email" name="email"
                            value="<?php echo e(old('email', Auth::user()->email)); ?>"
                            data-original-value="<?php echo e(Auth::user()->email); ?>" required>
                        <?php $__errorArgs = ['email', 'email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="mb-3">
                        <label for="password" class="form-label">Password Lama (untuk konfirmasi)</label>
                        <input type="password" class="form-control" id="password" name="password" required>
                        <?php $__errorArgs = ['password', 'email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function confirmLogout(e, url) {
    e.preventDefault();
    if (confirm('Apakah Anda yakin ingin keluar?')) {
        window.location.href = url;
    }
}

// Reset form saat modal ditutup (desktop & mobile)
document.querySelectorAll('.modal').forEach(modalEl => {
    modalEl.addEventListener('hidden.bs.modal', function() {
        const form = this.querySelector('form');
        if (form) {
            form.reset();
            this.querySelectorAll('[data-original-value]').forEach(input => {
                input.value = input.getAttribute('data-original-value');
            });
            this.querySelectorAll('.text-danger').forEach(el => el.remove());
        }
    });
});

// Auto-close & update UI setelah sukses
document.addEventListener('DOMContentLoaded', function() {
    <?php if(session('modal_success')): ?>
    const successType = '<?php echo e(session('
    modal_success ')); ?>';

    if (successType === 'username') {
        const modal = bootstrap.Modal.getInstance(document.getElementById('modalUsername'));
        if (modal) modal.hide();

        // Update username di desktop
        const desktopUsername = document.getElementById('display-username');
        if (desktopUsername) {
            desktopUsername.textContent = '<?php echo e(Auth::user()->name); ?>';
        }

        // Update username di mobile
        const mobileUsername = document.getElementById('mobile-display-username');
        if (mobileUsername) {
            mobileUsername.textContent = '<?php echo e(Auth::user()->name); ?>';
        }

        // Update nama di header mobile
        const mobileName = document.querySelector('.ios-name');
        if (mobileName) {
            mobileName.textContent = '<?php echo e(Auth::user()->name); ?>';
        }

        // Update avatar initial
        const avatarInitial = document.querySelector('.ios-avatar');
        if (avatarInitial) {
            avatarInitial.textContent = '<?php echo e(strtoupper(substr(Auth::user()->name ?? '
            U ', 0, 1))); ?>';
        }

    } else if (successType === 'password') {
        const modal = bootstrap.Modal.getInstance(document.getElementById('modalPassword'));
        if (modal) modal.hide();

    } else if (successType === 'email') {
        const modal = bootstrap.Modal.getInstance(document.getElementById('modalEmail'));
        if (modal) modal.hide();

        // Update email di desktop
        const desktopEmail = document.getElementById('display-email');
        if (desktopEmail) {
            desktopEmail.textContent = '<?php echo e(Auth::user()->email); ?>';
        }

        // Update email di mobile
        const mobileEmail = document.getElementById('mobile-display-email');
        if (mobileEmail) {
            mobileEmail.textContent = '<?php echo e(Auth::user()->email); ?>';
        }

        // Update email di header mobile
        const headerEmail = document.querySelectorAll('.ios-email')[0];
        if (headerEmail && !headerEmail.textContent.includes('<?php echo e(Auth::user()->role->name ?? '
                '); ?>')) {
            headerEmail.textContent = '<?php echo e(Auth::user()->email); ?>';
        }
    }
    <?php endif; ?>
});

// Hilangkan notifikasi sukses setelah 3 detik
setTimeout(() => {
    const alerts = document.querySelectorAll('.alert');
    alerts.forEach(alert => {
        const bsAlert = new bootstrap.Alert(alert);
        bsAlert.close();
    });
}, 3000);

// Tambahkan backdrop untuk mobile saat modal terbuka
document.addEventListener('DOMContentLoaded', function() {
    const isMobile = window.innerWidth < 992;

    if (isMobile) {
        // Force backdrop for mobile
        const modals = document.querySelectorAll('.modal');
        modals.forEach(modal => {
            modal.addEventListener('show.bs.modal', function() {
                // Ensure backdrop exists
                if (!document.querySelector('.modal-backdrop')) {
                    const backdrop = document.createElement('div');
                    backdrop.className = 'modal-backdrop fade show';
                    document.body.appendChild(backdrop);
                }
            });

            modal.addEventListener('hidden.bs.modal', function() {
                // Remove backdrop
                const backdrop = document.querySelector('.modal-backdrop');
                if (backdrop) {
                    backdrop.remove();
                }
            });
        });
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.AdminLayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\#PKL PROJECT\pklproject\resources\views/admin/settings.blade.php ENDPATH**/ ?>