<?php $__env->startSection('title', 'Admin Requests'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Header -->
    <div class="d-flex flex-column flex-lg-row justify-content-between align-items-start align-items-lg-center mb-4 gap-3">
        <div>
            <h1 class="dashboard-title">Admin Requests</h1>
            <?php if(request('search') || request('sort')): ?>
                <small class="text-muted d-block mt-1">
                    <i class="fas fa-filter me-1"></i>
                    <?php echo e($requests->total()); ?> pending requests
                    <?php if(request('search')): ?>
                         with keyword "<code><?php echo e(request('search')); ?></code>"
                    <?php endif; ?>
                    <?php if(request('sort') === 'name_asc'): ?>
                         <i class="fas fa-sort-alpha-down"></i> Name A→Z
                    <?php endif; ?>
                    <?php if(request('sort') === 'name_desc'): ?>
                         <i class="fas fa-sort-alpha-up"></i> Name Z→A
                    <?php endif; ?>
                </small>
            <?php endif; ?>
        </div>
        <?php if(request('search') || request('sort')): ?>
            <a href="<?php echo e(route('admin.adminrequest')); ?>" class="btn btn-sm btn-outline-secondary">
                <i class="fas fa-undo me-1"></i> Reset Filters
            </a>
        <?php endif; ?>
    </div>

    <!-- Search & Sort Bar -->
    <div class="card p-3 mb-4 rounded-4 shadow-sm border-0 bg-white">
        <form method="GET" class="row g-2 align-items-center">
            <div class="col-12 col-md-6">
                <div class="input-group">
                    <span class="input-group-text bg-light border-end-0">
                        <i class="fas fa-search text-secondary"></i>
                    </span>
                    <input type="text" name="search" class="form-control border-start-0 ps-0"
                        placeholder="Search by name or email..." value="<?php echo e(request('search')); ?>">
                </div>
            </div>
            <div class="col-12 col-md-6 text-md-end">
                <div class="btn-group shadow-sm" role="group">
                    <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'name_asc'])); ?>"
                        class="btn btn-sm <?php echo e(request('sort') === 'name_asc' ? 'btn-primary text-white' : 'btn-outline-secondary'); ?>">
                        <i class="fas fa-sort-alpha-down me-1"></i> A→Z
                    </a>
                    <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'name_desc'])); ?>"
                        class="btn btn-sm <?php echo e(request('sort') === 'name_desc' ? 'btn-primary text-white' : 'btn-outline-secondary'); ?>">
                        <i class="fas fa-sort-alpha-up me-1"></i> Z→A
                    </a>
                </div>
            </div>
        </form>
    </div>

    <!-- Success Alert -->
    <?php if(session('success')): ?>
        <div id="desktopSuccessAlert" class="alert alert-success alert-dismissible fade show mb-4 rounded-3 shadow-sm" role="alert">
            <i class="fas fa-check-circle me-2"></i>
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <!-- Request Grid -->
    <div class="requests-grid">
        <?php $__empty_1 = true; $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $req): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="request-card">
                <div class="d-flex align-items-center w-100">
                    <div class="avatar me-3">
                        <?php echo e(strtoupper(substr($req->user->name ?? 'U', 0, 1))); ?>

                    </div>
                    <div class="flex-grow-1 min-width-0">
                        <div class="request-name fw-semibold"><?php echo e($req->user->name); ?></div>
                        <div class="request-email text-secondary small text-truncate">
                            <i class="fas fa-envelope fa-xs me-1"></i><?php echo e($req->user->email); ?>

                        </div>
                    </div>
                    <div class="dropdown ms-2">
                        <button class="btn btn-icon btn-outline-secondary rounded-circle" type="button"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fas fa-ellipsis-v"></i>
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end shadow border-0 py-2">
                            <li>
                                <a class="dropdown-item text-success" href="#" data-bs-toggle="modal"
                                    data-bs-target="#approveModal" data-id="<?php echo e($req->id); ?>"
                                    data-name="<?php echo e(e($req->user->name)); ?>">
                                    <i class="fas fa-check-circle me-2"></i> Approve
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item text-danger" href="#" data-bs-toggle="modal"
                                    data-bs-target="#rejectModal" data-id="<?php echo e($req->id); ?>"
                                    data-name="<?php echo e(e($req->user->name)); ?>">
                                    <i class="fas fa-times-circle me-2"></i> Reject
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="empty-state text-center py-5">
                <div class="empty-state-icon mb-3">
                    <i class="fas fa-check-circle text-success" style="font-size: 3rem;"></i>
                </div>
                <h3 class="h5 fw-bold mb-2">All Requests Processed</h3>
                <p class="text-secondary mb-3">
                    <?php if(request('search')): ?>
                        No requests matching "<strong><?php echo e(request('search')); ?></strong>".
                    <?php else: ?>
                        There are no pending admin requests at the moment.
                    <?php endif; ?>
                </p>
                <?php if(request('search')): ?>
                    <a href="<?php echo e(route('admin.adminrequest')); ?>" class="btn btn-sm btn-outline-primary">
                        <i class="fas fa-list me-1"></i> View All
                    </a>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>

    <!-- Pagination -->
    <?php if($requests->hasPages()): ?>
        <div class="mt-4 d-flex justify-content-center">
            <?php echo e($requests->appends(request()->query())->links()); ?>

        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('mobile-content'); ?>
    <!-- Mobile overlay -->
    <div class="mobile-overlay">
        <!-- Topbar -->
        <div class="mobile-topbar">
            <a href="<?php echo e(route('admin.dashboard')); ?>" class="back-btn">
                <i class="fas fa-arrow-left"></i>
            </a>
            <h2 class="topbar-title">Admin Requests</h2>
            <button class="options-btn" id="optionsToggle">
                <i class="fas fa-ellipsis-v"></i>
            </button>
            <!-- Dropdown -->
            <div class="options-dropdown" id="optionsDropdown">
                <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'name_asc'])); ?>"
                    class="dropdown-item <?php echo e(request('sort') === 'name_asc' ? 'active' : ''); ?>">
                    <i class="fas fa-sort-alpha-down me-2"></i> Name (A→Z)
                </a>
                <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'name_desc'])); ?>"
                    class="dropdown-item <?php echo e(request('sort') === 'name_desc' ? 'active' : ''); ?>">
                    <i class="fas fa-sort-alpha-up me-2"></i> Name (Z→A)
                </a>
                <div class="dropdown-divider"></div>
                <a href="<?php echo e(route('admin.adminrequest')); ?>" class="dropdown-item text-secondary">
                    <i class="fas fa-undo me-2"></i> Reset Filters
                </a>
            </div>
        </div>

        <!-- Main Content -->
        <div class="mobile-main-content">
            <!-- Search Form -->
            <form method="GET" class="mb-3">
                <div class="input-group">
                    <input type="text" name="search" class="form-control rounded-start-pill"
                        placeholder="Search name/email..." value="<?php echo e(request('search')); ?>">
                    <button class="btn btn-primary rounded-end-pill" type="submit">
                        <i class="fas fa-search"></i>
                    </button>
                </div>
            </form>

            <!-- Summary -->
            <?php if(request('search') || request('sort')): ?>
                <div class="text-center small text-secondary mb-2">
                    <?php echo e($requests->total()); ?> requests found
                    <?php if(request('sort') === 'name_asc'): ?>
                         (sorted A→Z)
                    <?php elseif(request('sort') === 'name_desc'): ?>
                         (sorted Z→A)
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <!-- Alert -->
            <?php if(session('success')): ?>
                <div id="mobileSuccessAlert" class="alert alert-success mobile-alert mb-3">
                    <i class="fas fa-check-circle me-2"></i>
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <!-- Request List -->
            <div class="requests-list">
                <?php $__empty_1 = true; $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $req): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="request-card">
                        <div class="d-flex align-items-center w-100">
                            <div class="avatar me-3">
                                <?php echo e(strtoupper(substr($req->user->name ?? 'U', 0, 1))); ?>

                            </div>
                            <div class="flex-grow-1 min-width-0">
                                <div class="request-name fw-medium"><?php echo e($req->user->name); ?></div>
                                <div class="request-email text-secondary small text-truncate">
                                    <?php echo e($req->user->email); ?>

                                </div>
                            </div>
                            <div class="dropdown ms-2">
                                <button class="btn btn-icon btn-outline-secondary rounded-circle" type="button"
                                    data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="fas fa-ellipsis-v"></i>
                                </button>
                                <ul class="dropdown-menu dropdown-menu-end shadow border-0 py-2">
                                    <li>
                                        <a class="dropdown-item text-success" href="#" data-bs-toggle="modal"
                                            data-bs-target="#approveModal" data-id="<?php echo e($req->id); ?>"
                                            data-name="<?php echo e(e($req->user->name)); ?>">
                                            <i class="fas fa-check-circle me-2"></i> Approve
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item text-danger" href="#" data-bs-toggle="modal"
                                            data-bs-target="#rejectModal" data-id="<?php echo e($req->id); ?>"
                                            data-name="<?php echo e(e($req->user->name)); ?>">
                                            <i class="fas fa-times-circle me-2"></i> Reject
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="empty-state text-center py-4">
                        <i class="fas fa-check-circle text-success mb-2" style="font-size: 2rem;"></i>
                        <p class="text-secondary mb-0">
                            <?php if(request('search')): ?>
                                No results for "<strong><?php echo e(request('search')); ?></strong>".
                            <?php else: ?>
                                No pending requests.
                            <?php endif; ?>
                        </p>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Pagination (simple) -->
            <?php if($requests->hasPages()): ?>
                <div class="mt-3">
                    <?php echo e($requests->appends(request()->query())->links('pagination::simple-bootstrap-4')); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('modals'); ?>
    <!-- Approve Modal -->
    <div class="modal fade" id="approveModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0 rounded-4 shadow">
                <div class="modal-header border-0 pb-0">
                    <h5 class="modal-title text-success fw-bold">
                        <i class="fas fa-check-circle me-2"></i>Approve Request
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body text-center py-4 px-4">
                    <div class="bg-success bg-opacity-10 rounded-circle d-inline-flex p-3 mb-3">
                        <i class="fas fa-user-check fa-2x text-success"></i>
                    </div>
                    <p class="text-secondary mb-2">Are you sure you want to grant admin access to:</p>
                    <p class="fw-bold text-dark mb-1" id="modal-approve-name"></p>
                </div>
                <div class="modal-footer border-0 justify-content-between px-4 pb-4">
                    <button type="button" class="btn btn-outline-secondary rounded-pill px-4" data-bs-dismiss="modal">
                        <i class="fas fa-times me-1"></i>Cancel
                    </button>
                    <form id="approve-form" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PATCH'); ?>
                        <button type="submit" class="btn btn-success rounded-pill px-4">
                            <i class="fas fa-check me-1"></i>Approve
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Reject Modal -->
    <div class="modal fade" id="rejectModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0 rounded-4 shadow">
                <div class="modal-header border-0 pb-0">
                    <h5 class="modal-title text-danger fw-bold">
                        <i class="fas fa-times-circle me-2"></i>Reject Request
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body text-center py-4 px-4">
                    <div class="bg-danger bg-opacity-10 rounded-circle d-inline-flex p-3 mb-3">
                        <i class="fas fa-user-times fa-2x text-danger"></i>
                    </div>
                    <p class="text-secondary mb-2">Reject request from:</p>
                    <p class="fw-bold text-dark mb-1" id="modal-user-name"></p>
                    <p class="small text-secondary mt-2">
                        <i class="fas fa-exclamation-triangle me-1"></i> This action cannot be undone.
                    </p>
                </div>
                <div class="modal-footer border-0 justify-content-between px-4 pb-4">
                    <button type="button" class="btn btn-outline-secondary rounded-pill px-4" data-bs-dismiss="modal">
                        <i class="fas fa-times me-1"></i>Cancel
                    </button>
                    <form id="reject-form" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('POST'); ?>
                        <button type="submit" class="btn btn-danger rounded-pill px-4">
                            <i class="fas fa-trash-alt me-1"></i>Reject
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
    <style>
        :root {
            --bg-primary: #f8fafc;
            --card-bg: #ffffff;
            --text-primary: #1e293b;
            --text-secondary: #64748b;
            --border-light: #e2e8f0;
            --primary: #1e3a8a; /* Navy */
            --primary-hover: #1e40af;
            --primary-light: #dbeafe;
            --success: #10b981;
            --danger: #ef4444;
            --shadow-sm: 0 2px 6px rgba(0, 0, 0, 0.04);
            --shadow-md: 0 4px 12px rgba(0, 0, 0, 0.08);
            --shadow-lg: 0 10px 25px rgba(0, 0, 0, 0.12);
            --radius-md: 12px;
            --radius-lg: 16px;
        }

        body {
            background-color: var(--bg-primary);
        }

        /* Desktop styles */
        @media (min-width: 992px) {
            .dashboard-title {
                font-size: 2rem;
                font-weight: 700;
                color: var(--primary);
                margin-bottom: 0;
            }

            .requests-grid {
                display: grid;
                grid-template-columns: repeat(auto-fill, minmax(340px, 1fr));
                gap: 1.25rem;
            }

            .request-card {
                background: var(--card-bg);
                border-radius: var(--radius-md);
                padding: 1.25rem 1.5rem;
                box-shadow: var(--shadow-sm);
                border: 1px solid var(--border-light);
                transition: all 0.2s ease;
                display: flex;
                align-items: center;
                min-height: 100px; /* agar card tidak terlalu pendek */
            }

            .request-card:hover {
                transform: translateY(-2px);
                box-shadow: var(--shadow-md), 0 0 0 3px rgba(30, 58, 138, 0.1);
                border-color: var(--primary);
            }

            .avatar {
                width: 52px;
                height: 52px;
                border-radius: 50%;
                background: white;
                display: flex;
                align-items: center;
                justify-content: center;
                color: var(--primary);
                font-weight: 700;
                font-size: 1.3rem;
                box-shadow: var(--shadow-sm);
            }

            .request-name {
                font-size: 1.05rem;
                color: var(--text-primary);
                margin-bottom: 0.2rem;
            }

            .request-email {
                font-size: 0.9rem;
            }

            .btn-icon {
                width: 38px;
                height: 38px;
                border-radius: 50%;
                display: flex;
                align-items: center;
                justify-content: center;
                border: 1px solid var(--border-light);
                background: white;
                transition: all 0.2s;
            }

            .btn-icon:hover {
                background: #f1f5f9;
                border-color: var(--primary);
                color: var(--primary);
            }

            .empty-state {
                grid-column: 1 / -1;
                background: var(--card-bg);
                border-radius: var(--radius-lg);
                padding: 3rem 2rem;
                box-shadow: var(--shadow-sm);
                border: 1px solid var(--border-light);
            }
        }

        /* Mobile styles */
        @media (max-width: 991px) {
            .mobile-overlay {
                position: fixed;
                inset: 0;
                background: var(--bg-primary);
                z-index: 10000;
                display: flex;
                flex-direction: column;
            }

            .mobile-topbar {
                background: linear-gradient(145deg, #0f2b5c, #1e3a8a); /* Navy gradient */
                padding: 0.9rem 1.2rem;
                display: flex;
                align-items: center;
                justify-content: space-between;
                box-shadow: 0 6px 18px rgba(0, 20, 60, 0.4);
                position: sticky;
                top: 0;
                z-index: 10;
            }

            .back-btn, .options-btn {
                width: 40px;
                height: 40px;
                display: flex;
                align-items: center;
                justify-content: center;
                color: white;
                background: rgba(255, 255, 255, 0.15);
                border: none;
                border-radius: 10px;
                transition: background 0.2s;
                backdrop-filter: blur(5px);
            }

            .back-btn:hover, .options-btn:hover {
                background: rgba(255, 255, 255, 0.25);
            }

            .topbar-title {
                color: white;
                font-size: 1.2rem;
                font-weight: 600;
                letter-spacing: 0.3px;
                text-shadow: 0 2px 4px rgba(0,0,0,0.2);
            }

            .options-dropdown {
                position: absolute;
                top: 70px;
                right: 1.2rem;
                background: white;
                border-radius: 16px;
                box-shadow: var(--shadow-lg);
                width: 220px;
                display: none;
                z-index: 100;
                border: 1px solid var(--border-light);
                overflow: hidden;
            }

            .options-dropdown.show {
                display: block;
                animation: fadeInDown 0.25s ease;
            }

            @keyframes fadeInDown {
                from { opacity: 0; transform: translateY(-12px); }
                to { opacity: 1; transform: translateY(0); }
            }

            .dropdown-item {
                padding: 0.85rem 1.2rem;
                display: flex;
                align-items: center;
                color: var(--text-primary);
                text-decoration: none;
                font-size: 0.95rem;
                transition: background 0.2s;
            }

            .dropdown-item:hover {
                background: #f1f5f9;
            }

            .dropdown-item.active {
                background: #eef2ff;
                color: var(--primary);
                font-weight: 600;
            }

            .mobile-main-content {
                flex: 1;
                padding: 1.5rem 1.2rem;
                overflow-y: auto;
            }

            .request-card {
                background: var(--card-bg);
                border-radius: 16px;
                padding: 1rem 1.2rem;
                margin-bottom: 1rem;
                box-shadow: var(--shadow-sm);
                border: 1px solid var(--border-light);
                transition: all 0.2s;
            }

            .request-card:active {
                transform: scale(0.98);
                background: #f8fafc;
            }

            .avatar {
                width: 44px;
                height: 44px;
                border-radius: 50%;
                background: white;
                display: flex;
                align-items: center;
                justify-content: center;
                color: black;
                font-weight: 600;
                font-size: 1.1rem;
                box-shadow: 0 2px 8px rgba(0,0,0,0.05);
            }

            .btn-icon {
                width: 36px;
                height: 36px;
                border-radius: 50%;
                border: 1px solid var(--border-light);
                background: white;
                display: flex;
                align-items: center;
                justify-content: center;
                color: var(--text-secondary);
                transition: all 0.2s;
            }

            .btn-icon:active {
                background: #e2e8f0;
                transform: scale(0.95);
            }

            .mobile-alert {
                background: #ecfdf5;
                border: 1px solid #a7f3d0;
                color: #065f46;
                border-radius: 14px;
                padding: 0.9rem 1.2rem;
                animation: slideIn 0.3s ease;
                box-shadow: 0 4px 10px rgba(16, 185, 129, 0.15);
            }

            @keyframes slideIn {
                from { opacity: 0; transform: translateY(-12px); }
                to { opacity: 1; transform: translateY(0); }
            }

            .empty-state {
                background: white;
                border-radius: 20px;
                padding: 2.5rem 1rem;
                border: 1px solid var(--border-light);
                box-shadow: var(--shadow-sm);
            }
        }

        /* Common utilities */
        .min-width-0 {
            min-width: 0;
        }

        .btn-outline-secondary {
            border-color: var(--border-light);
            color: var(--text-secondary);
        }

        .btn-outline-secondary:hover {
            background: #f1f5f9;
            border-color: #94a3b8;
            color: var(--text-primary);
        }

        .btn-primary {
            background: var(--primary);
            border-color: var(--primary);
        }

        .btn-primary:hover {
            background: var(--primary-hover);
            border-color: var(--primary-hover);
        }

        .dropdown-menu {
            border-radius: 12px;
            animation: fadeIn 0.2s ease;
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        /* Auto-hide alert */
        .alert-success {
            transition: opacity 0.3s ease;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Modal data
            const approveModal = document.getElementById('approveModal');
            const rejectModal = document.getElementById('rejectModal');
            const approveForm = document.getElementById('approve-form');
            const rejectForm = document.getElementById('reject-form');
            const approveNameEl = document.getElementById('modal-approve-name');
            const rejectNameEl = document.getElementById('modal-user-name');

            approveModal.addEventListener('show.bs.modal', function(event) {
                const button = event.relatedTarget;
                const name = button.getAttribute('data-name');
                const id = button.getAttribute('data-id');
                approveNameEl.textContent = name;
                approveForm.action = "<?php echo e(route('admin.requests.approve', ['id' => '__ID__'])); ?>".replace('__ID__', id);
            });

            rejectModal.addEventListener('show.bs.modal', function(event) {
                const button = event.relatedTarget;
                const name = button.getAttribute('data-name');
                const id = button.getAttribute('data-id');
                rejectNameEl.textContent = name;
                rejectForm.action = "<?php echo e(route('admin.requests.reject', ['id' => '__ID__'])); ?>".replace('__ID__', id);
            });

            // Mobile dropdown toggle
            const optionsToggle = document.getElementById('optionsToggle');
            const optionsDropdown = document.getElementById('optionsDropdown');
            if (optionsToggle && optionsDropdown) {
                optionsToggle.addEventListener('click', function(e) {
                    e.stopPropagation();
                    optionsDropdown.classList.toggle('show');
                });
                document.addEventListener('click', function(e) {
                    if (!optionsDropdown.contains(e.target) && e.target !== optionsToggle) {
                        optionsDropdown.classList.remove('show');
                    }
                });
            }

            // Auto-hide alerts after 3 seconds
            const alerts = document.querySelectorAll('.alert-success');
            alerts.forEach(alert => {
                setTimeout(() => {
                    alert.style.opacity = '0';
                    setTimeout(() => alert.remove(), 300);
                }, 3000);
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.AdminLayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\#PKL PROJECT\pklproject\resources\views/admin/adminrequest.blade.php ENDPATH**/ ?>