<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ChecklistFillController;
use App\Http\Controllers\CheklistController;
use App\Http\Controllers\JadwalController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

Route::get('/', function () {
    return view('splash');
});

Route::get('/wlcm', function () {
    return view('wlcm');
});

/* ================= AUTH ================= */

Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::post('/register', [AuthController::class, 'register'])->name('register');
Route::get('/adminpending', [AuthController::class, 'pending'])->name('adminpending');
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

/* ================= ADMIN ================= */

Route::middleware(['auth'])->prefix('admin')->group(function () {

    Route::get('/dashboard', [AdminController::class, 'index'])
        ->name('admin.dashboard');

    Route::get('/adminrequest', [AdminController::class, 'request'])
        ->name('admin.adminrequest');

    Route::patch('/adminrequest/{id}/approve', [AdminController::class, 'approve'])
        ->name('admin.requests.approve');

    Route::post('/adminrequest/{id}/reject', [AdminController::class, 'reject'])
        ->name('admin.requests.reject');

     Route::get('/usermod', [AdminController::class, 'status'])
        ->name('admin.usermod');


    Route::get('/manajemen', [AdminController::class, 'indexman'])
        ->name('admin.manajemen');

    Route::get('/jadwal', [AdminController::class, 'indexjad'])->name('admin.jadwal');

    Route::get('/settings', [AdminController::class, 'indexset'])
        ->name('admin.settings');

    Route::put('/settings/edit-username', [AdminController::class, 'updateUsername'])->name('settings.update.username');
    Route::put('/settings/edit-password', [AdminController::class, 'updatePassword'])->name('settings.update.password');
    Route::put('/settings/edit-email', [AdminController::class, 'updateEmail'])->name('settings.update.email');

    Route::prefix('manajemen')->group(function () {
        Route::get('/checklist', [CheklistController::class, 'index'])->name('admin.manajemen.checklist');
        Route::post('/checklist', [CheklistController::class, 'store'])->name('checklist.add');
        Route::put('/checklist/{id}', [CheklistController::class, 'update'])->name('checklist.edit');
        Route::delete('/checklist/{id}', [CheklistController::class, 'destroy'])->name('checklist.delete');

        Route::get('/section/{id}', [CheklistController::class, 'sectionindex'])->name('admin.manajemen.section');
        Route::post('/section', [CheklistController::class, 'sectionstore'])->name('section.add');
        Route::put('/section/{id}', [CheklistController::class, 'sectionupdate'])->name('section.edit');
        Route::delete('/section/{id}', [CheklistController::class, 'sectiondestroy'])->name('section.delete');

        Route::post('/question', [CheklistController::class, 'questionstore'])->name('admin.manajemen.question.store');
        Route::get('/questions/{id}/edit', [CheklistController::class, 'questionedit'])->name('admin.manajemen.question.edit');
        Route::put('/question/{id}', [CheklistController::class, 'questionupdate'])->name('admin.manajemen.question.update');
        Route::delete('/questions/{id}', [CheklistController::class, 'questiondestroy'])->name('admin.question.destroy');

        Route::get('/usermanajemen', [AdminController::class, 'userman'])->name('admin.manajemen.usermanajemen');
        Route::delete('/usermanajemen/{user}', [AdminController::class, 'userdestroy'])->name('users.destroy');
    });

    // ✅ JADWAL ROUTES
    Route::prefix('jadwal')->group(function () {
        Route::post('/store', [JadwalController::class, 'store'])
            ->name('jadwal.store');

        Route::get('/list', [JadwalController::class, 'index'])
            ->name('jadwal.index');

        Route::put('/{id}', [JadwalController::class, 'update'])->name('jadwal.update');

        Route::get('/{id}', [JadwalController::class, 'show'])
            ->name('jadwal.show');

        Route::delete('/{id}', [JadwalController::class, 'destroy'])
            ->name('jadwal.destroy');

        Route::get('/images/list', [JadwalController::class, 'getScheduleImages'])
            ->name('jadwal.images.list');

        Route::delete('/images/delete', [JadwalController::class, 'deleteScheduleImage'])
            ->name('jadwal.images.delete');

        Route::post('/upload', [JadwalController::class, 'uploadScheduleImage'])
            ->name('jadwal.upload');
    });

});

/* ================= USER ================= */

Route::middleware(['auth'])->prefix('user')->name('user.')->group(function () {

    // Dashboard
    Route::get('/dashboard', [UserController::class, 'index'])->name('dashboard');

    // Mod Menu - Halaman utama checklist
    Route::get('/mod', [UserController::class, 'mod'])->name('mod');
    Route::post('/mod/submit', [UserController::class, 'submitMod'])->name('mod.submit');

    Route::get('/jadwal', [UserController::class, 'jadwal'])->name('jadwal');

    Route::get('/profile', [UserController::class, 'profile'])->name('profile');
    Route::put('/profile/edit-username', [UserController::class, 'updateUsername'])->name('profile.update.username');
    Route::put('/profile/edit-password', [UserController::class, 'updatePassword'])->name('profile.update.password');
    Route::put('/profile/edit-email', [UserController::class, 'updateEmail'])->name('profile.update.email');

    // ✅ CHECKLIST FILLING - ROUTE YANG BENAR
    Route::prefix('checklist')->name('checklist.')->group(function () {
        // Fill checklist (multi-step)
        Route::get('/fill/{checklistId}/{step?}', [ChecklistFillController::class, 'fill'])
            ->name('fill')
            ->whereNumber('checklistId')
            ->whereNumber('step');

        // Simpan jawaban per section
        Route::post('/save/{checklistId}/{step}', [ChecklistFillController::class, 'save'])
            ->name('save')
            ->whereNumber('checklistId')
            ->whereNumber('step');

        // Simpan nomor kamar (khusus Room Inspection)
        Route::post('/save-room-number/{submissionId}', [ChecklistFillController::class, 'saveRoomNumber'])
            ->name('save-room-number')
            ->whereNumber('submissionId');

        // Halaman selesai submit
        Route::get('/finish/{checklistId}', [ChecklistFillController::class, 'finish'])
            ->name('finish')
            ->whereNumber('checklistId');

        // Preview/Review checklist
        Route::get('/review/{checklistId}', [ChecklistFillController::class, 'review'])
            ->name('review')
            ->whereNumber('checklistId');

        // Resume/Edit submission yang belum selesai
        Route::get('/resume/{submissionId}/{step?}', [ChecklistFillController::class, 'resume'])
            ->name('resume')
            ->whereNumber('submissionId')
            ->whereNumber('step');

        // Delete image
        Route::post('/delete-image', [ChecklistFillController::class, 'deleteImage'])
            ->name('delete-image');

         Route::post('/reset-progress/{submissionId}', [ChecklistFillController::class, 'resetProgress'])
            ->name('reset-progress');

         Route::post('/validate-room-number', [ChecklistFillController::class, 'validateRoomNumber'])
            ->name('validate-room-number');

         // AUTO-SAVE ROUTE
        Route::post('/auto-save/{checklistId}/{step}', [ChecklistFillController::class, 'autoSave'])
            ->name('auto-save');

        Route::get('/report/{checklistId}', [ChecklistFillController::class, 'report'])
        ->name('report')
        ->whereNumber('checklistId');
    });


// Home route (redirect ke dashboard)
    Route::get('/', function () {
        return redirect()->route('user.dashboard');
    })->middleware('auth');
});
