<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Welcome to Harris Pop</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        /* ========== Page Transition (Modern API) ========== */
        ::page-transition {
            animation-duration: 0.4s;
        }

        ::page-transition-container(root) {
            animation: none;
        }

        ::page-transition-outgoing-image(root),
        ::page-transition-incoming-image(root) {
            animation: none;
        }

        /* Fade-in universal fallback (untuk semua browser) */
        body {
            /* Default state saat load */
            opacity: 0;
            transition: opacity 0.45s cubic-bezier(0.34, 1.56, 0.64, 1);
        }

        /* Trigger fade-in setelah DOM siap */
        body.appear {
            opacity: 1;
        }

        /* ========== Reset & Variabel Warna ========== */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        :root {
            --navy: #0f2a4d;
            --navy-dark: #0a1e3a;
            --accent: #5d8fd9;
            --text-primary: #1e293b;
            --text-secondary: #475569;
            --bg: #ffffff;
        }

        @media (prefers-color-scheme: dark) {
            :root {
                --text-primary: #f1f5f9;
                --text-secondary: #cbd5e1;
                --bg: #0c1a33;
            }
        }

        body {
            background-color: var(--bg);
            color: var(--text-primary);
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            font-weight: 400;
            line-height: 1.6;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 1.5rem;
            text-align: center;
            /* Penting: pastikan background tidak "flash" */
            background: var(--bg) !important;
        }

        /* ========== Wave Header (Navy, Minimal) ========== */
        .wave {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 180px;
            background: var(--navy);
            clip-path: path("M0,120 Q360,160 720,110 Q1080,60 1440,100 L1440,0 L0,0 Z");
            z-index: -1;
            opacity: 0;
            animation: waveAppear 0.6s ease-out 0.1s forwards;
        }

        @keyframes waveAppear {
            to { opacity: 1; }
        }

        /* ========== Konten Utama ========== */
        .content {
            max-width: 600px;
            width: 100%;
            padding: 0 1rem;
            opacity: 0;
            transform: translateY(15px);
            animation: contentAppear 0.7s ease-out 0.2s forwards;
        }

        .content h1 {
            font-weight: 700;
            font-size: clamp(2rem, 6vw, 3.2rem);
            margin-bottom: 1rem;
            color: var(--navy);
        }

        @media (prefers-color-scheme: dark) {
            .content h1 {
                color: #e2e8f0;
            }
        }

        .content p {
            font-weight: 300;
            font-size: clamp(1rem, 4.2vw, 1.25rem);
            color: var(--text-secondary);
            margin-bottom: 2.25rem;
        }

        /* ========== Tombol Sederhana tapi Elegan ========== */
        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 0.65rem;
            background: transparent;
            color: var(--navy);
            font-weight: 600;
            font-size: clamp(1rem, 3.8vw, 1.15rem);
            padding: 0.75rem 1.75rem;
            border: 2px solid var(--navy);
            border-radius: 50px;
            text-decoration: none;
            transition: all 0.3s ease;
        }

        @media (prefers-color-scheme: dark) {
            .btn {
                color: #cbd5e1;
                border-color: #64748b;
            }
            .btn:hover {
                color: #f1f5f9;
                border-color: #94a3b8;
            }
        }

        .btn:hover {
            background: var(--navy);
            color: white;
            transform: translateY(0) scale(1.02);
        }

        .btn:focus {
            outline: 2px solid var(--accent);
            outline-offset: 4px;
        }

        .btn::after {
            content: "→";
            font-weight: 500;
            display: inline-block;
            transition: transform 0.3s ease;
        }

        .btn:hover::after {
            transform: translateX(3px);
        }

        /* ========== Animasi Konten ========== */
        @keyframes contentAppear {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* ========== Responsif ========== */
        @media (max-width: 480px) {
            body {
                padding: 2rem 1rem;
            }

            .content h1 {
                font-size: clamp(1.8rem, 8vw, 2.6rem);
            }

            .content p {
                font-size: clamp(0.95rem, 5vw, 1.1rem);
                margin-bottom: 2rem;
            }

            .btn {
                font-size: clamp(0.95rem, 4.5vw, 1.05rem);
                padding: 0.7rem 1.6rem;
            }
        }

        /* Nonaktifkan animasi jika pengguna memilih reduce motion */
        @media (prefers-reduced-motion: reduce) {
            body {
                transition: none !important;
                opacity: 1 !important;
            }
            .wave,
            .content {
                animation: none !important;
                opacity: 1 !important;
                transform: none !important;
            }
        }
    </style>
</head>
<body>
    <!-- Wave Header Minimal (Navy) -->
    <div class="wave"></div>

    <!-- Konten Utama -->
    <div class="content">
        <h1>Welcome to MOD<br>Harris Pop</h1>
        <p>Solusi elegan untuk manajemen dan pemeliharaan ruangan hotel — sederhana, andal, dan dirancang untuk Anda.</p>
        <a href="/login" class="btn" aria-label="Lanjutkan ke halaman login">Lanjutkan</a>
    </div>

    <script>
        // === Page Transition (Modern) ===
        if ('pageTransition' in document) {
            // Nyalakan Page Transition API (jika didukung)
            // Transisi otomatis saat navigate ke/dari halaman ini
        }

        // === Fallback Universal Fade-In ===
        document.addEventListener('DOMContentLoaded', () => {
            // Tunda sedikit agar tidak terlalu cepat (terutama setelah splash 2s)
            setTimeout(() => {
                document.body.classList.add('appear');
            }, 50); // 50ms: cukup untuk hindari FOUC, tapi tidak terasa delay
        });

        // === Opsional: Trigger transisi saat datang dari splash dengan fade-out ===
        // Jika splash screen pakai class `.fade-out`, kita bisa deteksi via Performance API
        // Tapi fallback di atas sudah cukup untuk 99% kasus.
    </script>
</body>
</html>
