@extends('layouts.UserLayout')

@push('styles')
<style>
/* ================= BASE STYLES ================= */
body {
    background: #f8fafc;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    margin: 0;
    padding: 0;
}

/* ================= DESKTOP LAYOUT ================= */
@media (min-width: 769px) {
    .desktop-container {
        max-width: 900px;
        margin: 0 auto;
        padding: 20px;
    }
    .mobile-container {
        display: none;
    }
    .room-number-display-container {
        margin-bottom: 32px;
    }
    .room-number-display-container .instruction {
        font-size: 1.1rem;
        color: #4b5563;
        margin-bottom: 8px;
    }
    .room-number-display {
        font-size: 1.8rem;
        font-weight: bold;
        color: #1e40af;
        background: #eff6ff;
        padding: 16px 24px;
        border-radius: 10px;
        border: 2px solid #3b82f6;
        display: inline-block;
        min-width: 150px;
        text-align: center;
    }
    .form-desktop {
        background: white;
        border-radius: 16px;
        padding: 32px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.05);
    }
    .question-card-desktop {
        background: white;
        border-radius: 12px;
        padding: 24px;
        margin-bottom: 20px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        border: 1px solid #e5e7eb;
        transition: transform 0.2s, box-shadow 0.2s;
    }
    .question-card-desktop:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }
    .question-title-desktop {
        font-weight: 600;
        font-size: 1.1rem;
        color: #111827;
        margin-bottom: 16px;
        padding-bottom: 12px;
        border-bottom: 1px solid #f3f4f6;
        word-break: break-word;
        line-height: 1.5;
    }
    .navigation-desktop {
        display: flex;
        justify-content: space-between;
        margin-top: 40px;
        padding-top: 24px;
        border-top: 1px solid #e5e7eb;
    }
    .btn-desktop {
        padding: 14px 32px;
        border-radius: 10px;
        border: none;
        font-weight: 600;
        cursor: pointer;
        font-size: 1rem;
        transition: all 0.2s;
        text-decoration: none;
        display: inline-block;
        text-align: center;
        min-width: 150px;
    }
}

/* ================= MOBILE LAYOUT ================= */
@media (max-width: 768px) {
    .desktop-container {
        display: none;
    }
    .mobile-container {
        padding: 0;
        background: #f8fafc;
        min-height: auto;
    }
    .form-mobile {
        padding: 16px;
        padding-bottom: 20px;
    }
    .question-card-mobile {
        background: white;
        border-radius: 12px;
        padding: 16px;
        margin-bottom: 12px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        border: 1px solid #e5e7eb;
    }
    .question-title-mobile {
        font-weight: 600;
        font-size: 1rem;
        color: #111827;
        margin-bottom: 12px;
        padding-bottom: 8px;
        border-bottom: 1px solid #f3f4f6;
        word-break: break-word;
        line-height: 1.4;
    }
    .navigation-mobile {
        position: relative;
        bottom: auto;
        left: auto;
        right: auto;
        background: white;
        padding: 12px 16px;
        border-top: 1px solid #e5e7eb;
        display: flex;
        justify-content: space-between;
        z-index: auto;
        box-shadow: none;
        margin-top: 20px;
        width: 100%;
    }
    .btn-mobile {
        padding: 14px 20px;
        border-radius: 10px;
        border: none;
        font-weight: 600;
        cursor: pointer;
        font-size: 0.95rem;
        transition: all 0.2s;
        text-decoration: none;
        display: inline-block;
        text-align: center;
        flex: 1;
        margin: 0 4px;
    }
}

/* ================= COMMON STYLES ================= */
.required-star {
    color: #ef4444;
    margin-left: 5px;
}
.answer-options {
    display: flex;
    gap: 24px;
    margin: 16px 0;
    flex-wrap: wrap;
}
.answer-option {
    display: flex;
    align-items: center;
    gap: 10px;
    cursor: pointer;
    padding: 8px 0;
}
.answer-option input[type="radio"] {
    width: 20px;
    height: 20px;
    cursor: pointer;
}
.comment-box {
    margin-top: 16px;
}
.comment-box textarea {
    width: 100%;
    padding: 14px;
    border: 1px solid #d1d5db;
    border-radius: 10px;
    resize: vertical;
    min-height: 100px;
    font-family: inherit;
    font-size: 0.95rem;
    line-height: 1.5;
}
.image-upload {
    margin-top: 16px;
}
.image-upload label {
    display: block;
    margin-bottom: 8px;
    color: #4b5563;
    font-weight: 500;
    font-size: 0.95rem;
}
.image-preview {
    margin-top: 12px;
    max-width: 100%;
}
.image-preview img {
    width: 100%;
    border-radius: 10px;
    border: 1px solid #d1d5db;
    max-height: 250px;
    object-fit: cover;
}
.remove-image {
    color: #ef4444;
    cursor: pointer;
    font-size: 0.875rem;
    margin-top: 6px;
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 6px 12px;
    border-radius: 6px;
    background: #fee2e2;
    border: none;
    font-weight: 500;
}
.remove-image:hover {
    background: #fecaca;
}
.sub-question {
    background: #f9fafb;
    border-radius: 10px;
    padding: 16px;
    margin-top: 12px;
    border-left: 4px solid #3b82f6;
}
.sub-question-title {
    font-weight: 500;
    margin-bottom: 12px;
    color: #374151;
    font-size: 0.95rem;
    word-break: break-word;
    line-height: 1.4;
}
.btn-prev {
    background: #f3f4f6;
    color: #374151;
}
.btn-prev:hover, .btn-prev:active {
    background: #e5e7eb;
}
.btn-next {
    background: #3b82f6;
    color: white;
}
.btn-next:hover, .btn-next:active {
    background: #2563eb;
}
.btn-submit {
    background: #10b981;
    color: white;
}
.btn-submit:hover, .btn-submit:active {
    background: #059669;
}
.btn-primary-custom {
    background: #3b82f6;
    color: white;
}
.btn-primary-custom:hover, .btn-primary-custom:active {
    background: #2563eb;
}
.error-message {
    color: #ef4444;
    font-size: 0.875rem;
    margin-top: 6px;
    padding: 8px 12px;
    background: #fee2e2;
    border-radius: 6px;
    border-left: 4px solid #ef4444;
}
.success-message {
    background: #d1fae5;
    color: #065f46;
    padding: 16px;
    border-radius: 10px;
    margin-bottom: 20px;
    border-left: 4px solid #10b981;
    font-size: 0.95rem;
}
.alert-message {
    background: #fee2e2;
    color: #991b1b;
    padding: 16px;
    border-radius: 10px;
    margin-bottom: 20px;
    border-left: 4px solid #ef4444;
    font-size: 0.95rem;
}
.no-questions {
    text-align: center;
    padding: 48px 20px;
    color: #6b7280;
    background: white;
    border-radius: 12px;
    margin: 24px 0;
    box-shadow: 0 2px 4px rgba(0,0,0,0.05);
}
.section-header {
    background: #1e40af;
    color: white;
    padding: 20px;
    border-radius: 12px;
    margin-bottom: 20px;
    font-weight: 700;
    font-size: 1.2rem;
    text-align: center;
}
.readonly-text {
    background: #f8fafc;
    border-left: 4px solid #64748b;
    color: #475569;
    padding: 20px;
    margin-bottom: 20px;
    border-radius: 12px;
    font-size: 0.95rem;
    line-height: 1.6;
}
.page-note {
    background: #f0fdf4;
    border-left: 4px solid #10b981;
    color: #047857;
    padding: 20px;
    margin-bottom: 20px;
    border-radius: 12px;
    font-style: italic;
    font-size: 0.95rem;
    line-height: 1.6;
}
.image-required-badge {
    background: #fee2e2;
    color: #991b1b;
    font-size: 0.75rem;
    padding: 3px 10px;
    border-radius: 12px;
    margin-left: 10px;
    font-weight: 600;
}
input[type="file"] {
    width: 100%;
    padding: 12px;
    border: 2px dashed #d1d5db;
    border-radius: 10px;
    background: #f9fafb;
    cursor: pointer;
    transition: border-color 0.2s;
}
input[type="file"]:hover {
    border-color: #3b82f6;
}
input[type="file"]::file-selector-button {
    background: #3b82f6;
    color: white;
    border: none;
    padding: 8px 16px;
    border-radius: 6px;
    margin-right: 12px;
    cursor: pointer;
    font-weight: 500;
    transition: background 0.2s;
}
input[type="file"]::file-selector-button:hover {
    background: #2563eb;
}
.overall-comment-card {
    background: white;
    border-radius: 12px;
    padding: 24px;
    margin-bottom: 24px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    border: 1px solid #e5e7eb;
}
.overall-comment-card h3 {
    margin: 0 0 16px 0;
    color: #1f2937;
    font-size: 1.25rem;
    font-weight: 700;
}
.overall-comment-textarea {
    min-height: 120px;
}
/* ============== EXIT CONFIRMATION MODAL ============== */
.exit-confirmation-modal {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0,0,0,0.5);
    z-index: 10000;
    align-items: center;
    justify-content: center;
}
.modal-content {
    background: white;
    border-radius: 16px;
    padding: 32px;
    max-width: 400px;
    width: 90%;
    box-shadow: 0 10px 25px rgba(0,0,0,0.2);
    text-align: center;
}
.modal-title {
    font-size: 1.5rem;
    font-weight: 700;
    color: #1f2937;
    margin-bottom: 16px;
}
.modal-message {
    color: #6b7280;
    font-size: 1rem;
    line-height: 1.6;
    margin-bottom: 24px;
}
.modal-buttons {
    display: flex;
    gap: 12px;
    justify-content: center;
}
.modal-btn {
    padding: 12px 24px;
    border-radius: 10px;
    font-weight: 600;
    cursor: pointer;
    border: none;
    font-size: 1rem;
    flex: 1;
}
.modal-btn-cancel {
    background: #f3f4f6;
    color: #374151;
}
.modal-btn-cancel:hover {
    background: #e5e7eb;
}
.modal-btn-confirm {
    background: #ef4444;
    color: white;
}
.modal-btn-confirm:hover {
    background: #dc2626;
}
/* Room Inspection Header */
.room-inspection-header {
    background: white;
    padding: 32px;
    border-radius: 16px;
    box-shadow: 0 4px 6px rgba(0,0,0,0.05);
    margin-bottom: 32px;
    border: 1px solid #e5e7eb;
    text-align: center;
}
.room-inspection-header h1 {
    margin: 0 0 24px 0;
    color: #1f2937;
    font-size: 2rem;
    font-weight: 800;
}
.room-number-input-container {
    margin-bottom: 32px;
}
.room-number-input-container .instruction {
    font-size: 1.1rem;
    color: #4b5563;
    margin-bottom: 12px;
}
.room-number-input {
    width: 300px;
    padding: 16px;
    font-size: 1.2rem;
    text-align: center;
    border: 2px solid #d1d5db;
    border-radius: 10px;
    display: inline-block;
}
.room-number-input:focus {
    border-color: #3b82f6;
    outline: none;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}
.room-progress-indicator {
    display: inline-flex;
    background: #f3f4f6;
    padding: 8px 16px;
    border-radius: 20px;
    font-size: 0.95rem;
    color: #6b7280;
}
.room-progress-indicator .progress-text {
    font-weight: 600;
}
.room-progress-indicator .progress-value {
    margin-left: 8px;
    color: #1f2937;
    font-weight: 700;
}
/* Mobile Room Inspection Header */
.room-inspection-header-mobile {
    background: white;
    padding: 20px;
    border-radius: 12px;
    margin-bottom: 20px;
    border: 1px solid #e5e7eb;
    text-align: center;
}
.room-inspection-header-mobile h1 {
    margin: 0 0 16px 0;
    color: #1f2937;
    font-size: 1.5rem;
    font-weight: 700;
}
.room-number-input-mobile {
    width: 100%;
    max-width: 250px;
    padding: 14px;
    font-size: 1.1rem;
    text-align: center;
    border: 2px solid #d1d5db;
    border-radius: 8px;
    display: inline-block;
    margin-bottom: 16px;
}
.room-number-display-mobile {
    font-size: 1.4rem;
    font-weight: bold;
    color: #1e40af;
    background: #eff6ff;
    padding: 12px 20px;
    border-radius: 8px;
    border: 2px solid #3b82f6;
    display: inline-block;
    min-width: 120px;
    text-align: center;
    margin-bottom: 16px;
}
.room-progress-indicator-mobile {
    display: inline-flex;
    background: #f3f4f6;
    padding: 6px 12px;
    border-radius: 20px;
    font-size: 0.9rem;
    color: #6b7280;
}
/* Auto-save Status */
.auto-save-status {
    font-size: 0.85rem;
    color: #6b7280;
    text-align: center;
    margin-top: 8px;
    font-style: italic;
}
.auto-save-status.saved {
    color: #10b981;
    font-weight: 500;
}

/* SAFETY NET: Hide mobile navigation on desktop */
@media (min-width: 1024px) {
    .navigation-mobile {
        display: none !important;
    }
}
</style>
@endpush

@section('content')
<meta name="submission-id" content="{{ $submission->id }}">
<meta name="reset-progress-url" content="{{ route('user.checklist.reset-progress', ['submissionId' => $submission->id]) }}">
<meta name="redirect-url" content="{{ route('user.dashboard') }}">
<meta name="csrf-token" content="{{ csrf_token() }}">

<div class="desktop-container">
    {{-- Exit Confirmation Modal --}}
    <div id="exitModal" class="exit-confirmation-modal">
        <div class="modal-content">
            <h3 class="modal-title">Unsaved Changes</h3>
            <p class="modal-message">Your progress has not been saved automatically yet. Are you sure you want to leave? All unsaved data will be lost.</p>
            <div class="modal-buttons">
                <button id="cancelExit" class="modal-btn modal-btn-cancel">Cancel</button>
                <button id="confirmExit" class="modal-btn modal-btn-confirm">Leave Without Saving</button>
            </div>
        </div>
    </div>

    {{-- Success/Error Messages --}}
    @if(session('success'))
        <div class="success-message">
            {{ session('success') }}
        </div>
    @endif
    @if(session('error'))
        <div class="alert-message">
            {{ session('error') }}
        </div>
    @endif

    {{-- Desktop Form --}}
    <div class="form-desktop">
        <form method="POST"
              action="{{ route('user.checklist.save', ['checklistId' => $checklist->id, 'step' => $step]) }}"
              enctype="multipart/form-data"
              id="checklistFormDesktop">
            @csrf

            @if(isset($isResume) && $isResume)
                <input type="hidden" name="is_resume" value="1">
            @endif

            @if($checklist->mod_type === 'room_inspection')
                <div class="room-inspection-header">
                   <h1>{{ $checklist->hotel }} - Room Inspection ({{ $roomCount + 1 }}/5)</h1>
                    
                    @if($step == 0)
                        {{-- Show input only in first section --}}
                        <div class="room-number-input-container">
                            <div class="instruction">Please enter room number for room {{ $roomCount + 1 }}:</div>
                            <input type="text"
                                   name="room_number"
                                   id="room_number"
                                   value="{{ old('room_number', $roomNumber ?? '') }}"
                                   placeholder="Room no"
                                   class="room-number-input"
                                   required>
                            @error('room_number')
                                <div class="error-message" style="max-width: 300px; margin: 12px auto 0;">{{ $message }}</div>
                            @enderror
                        </div>
                    @else
                        {{-- In section > 0, show room number as read-only --}}
                        <div class="room-number-display-container">
                            <div class="instruction">Room {{ $roomCount + 1 }} - Room Number:</div>
                            <div class="room-number-display">
                                <strong>{{ $roomNumber ?? 'Not entered' }}</strong>
                            </div>
                            {{-- Hidden input to keep sending room_number --}}
                            <input type="hidden" name="room_number" value="{{ $roomNumber }}">
                        </div>
                    @endif

                    {{-- Progress Indicator --}}
                    <div class="room-progress-indicator">
                        <span class="progress-text">Progress:</span>
                        <span class="progress-value">
                            Room {{ $roomCount + 1 }} of 5 -
                            Section {{ $step + 1 }} of {{ $totalSteps }}
                        </span>
                    </div>
                </div>
            @endif

            {{-- Questions --}}
            @if($questions->count() > 0)
                @foreach($questions as $question)
                    @php
                        $oldAnswer = $questionAnswers[$question->id] ?? null;
                        $answerValue = $oldAnswer->answer_yes_no ?? old("question.{$question->id}.answer_yes_no");
                        $commentValue = $oldAnswer->comment ?? old("question.{$question->id}.comment");
                        $hasImage = !empty($oldAnswer?->image_path);
                        $validValues = ($checklist->mod_type === 'room_inspection') ? ['good', 'bad'] : ['yes', 'no'];
                        $labels = ($checklist->mod_type === 'room_inspection') ? ['Good', 'Bad'] : ['Yes', 'No'];
                    @endphp

                    <div class="question-card-desktop" id="question-desktop-{{ $question->id }}">
                        {{-- Header Type --}}
                        @if($question->type === 'header')
                            <div class="section-header">
                                {{ $question->question_text }}
                            </div>
                        {{-- Read Only Text --}}
                        @elseif($question->type === 'readOnlyText')
                            <div class="readonly-text">
                                {{ $question->question_text }}
                            </div>
                        {{-- Page Note --}}
                        @elseif($question->type === 'pageNote')
                            <div class="page-note">
                                ℹ️ {{ $question->question_text }}
                            </div>
                        {{-- Other Question Types --}}
                        @else
                            <div class="question-title-desktop">
                                {{ $question->question_text }}
                                @if($question->is_required && !in_array($question->type, ['header', 'readOnlyText', 'pageNote']))
                                    <span class="required-star">*</span>
                                @endif
                                @if($question->image_required_if_no)
                                    <span class="image-required-badge">Photo required if {{ $labels[1] }}</span>
                                @endif
                            </div>

                            {{-- Yes/No Question --}}
                            @if($question->type === 'yesNo')
                                <div class="answer-options">
                                    <label class="answer-option">
                                        <input type="radio" name="question[{{ $question->id }}][answer_yes_no]"
                                               value="{{ $validValues[0] }}" {{ $answerValue === $validValues[0] ? 'checked' : '' }}
                                               data-question-id="{{ $question->id }}" {{ $question->is_required ? 'required' : '' }}>
                                        <span>{{ $labels[0] }}</span>
                                    </label>
                                    <label class="answer-option">
                                        <input type="radio" name="question[{{ $question->id }}][answer_yes_no]"
                                               value="{{ $validValues[1] }}" {{ $answerValue === $validValues[1] ? 'checked' : '' }}
                                               data-question-id="{{ $question->id }}" {{ $question->is_required ? 'required' : '' }}>
                                        <span>{{ $labels[1] }}</span>
                                    </label>
                                </div>
                                @error("question.{$question->id}.answer_yes_no")
                                    <div class="error-message">{{ $message }}</div>
                                @enderror

                                {{-- Comment Field --}}
                                @if($question->has_comment)
                                    <div class="comment-box">
                                        <textarea name="question[{{ $question->id }}][comment]"
                                                  placeholder="Add comment...">{{ $commentValue }}</textarea>
                                        @error("question.{$question->id}.comment")
                                            <div class="error-message">{{ $message }}</div>
                                        @enderror
                                    </div>
                                @endif

                                {{-- Image Upload --}}
                                @if($question->image_required_if_no)
                                    @php
                                        $showImageUpload = in_array($answerValue, ['no', 'bad']);
                                    @endphp
                                    <div class="image-upload" id="image-upload-{{ $question->id }}" style="{{ $showImageUpload ? '' : 'display:none;' }}">
                                        <label>Upload Image (required if answer is {{ $labels[1] }}):</label>
                                        <input type="file" name="question[{{ $question->id }}][image]"
                                               accept="image/*" class="form-control image-upload-input"
                                               data-question-id="{{ $question->id }}"
                                               {{ $showImageUpload && !$hasImage ? 'required' : '' }}>
                                        @if($hasImage)
                                            <input type="hidden" name="question[{{ $question->id }}][existing_image]"
                                                   value="{{ $oldAnswer->image_path }}">
                                            <div class="image-preview" id="preview-desktop-{{ $question->id }}">
                                                <img src="{{ Storage::url($oldAnswer->image_path) }}" alt="Preview">
                                                <button type="button" class="remove-image" onclick="deleteImage('question', {{ $oldAnswer->id }}, {{ $question->id }}, 'desktop')">
                                                     Remove image
                                                </button>
                                            </div>
                                        @endif
                                        @error("question.{$question->id}.image")
                                            <div class="error-message">{{ $message }}</div>
                                        @enderror
                                    </div>
                                @endif
                            @endif

                            {{-- Image Upload Only --}}
                            @if($question->type === 'imageUpload')
                                <div class="image-upload">
                                    <label>Upload Image {{ $question->is_required ? '(required)' : '(optional)' }}:</label>
                                    <input type="file" name="question[{{ $question->id }}][image]"
                                           accept="image/*" class="form-control image-upload-input"
                                           data-question-id="{{ $question->id }}"
                                           {{ $question->is_required && !$hasImage ? 'required' : '' }}>
                                    @if($hasImage)
                                        <input type="hidden" name="question[{{ $question->id }}][existing_image]"
                                               value="{{ $oldAnswer->image_path }}">
                                        <div class="image-preview" id="preview-desktop-{{ $question->id }}">
                                            <img src="{{ Storage::url($oldAnswer->image_path) }}" alt="Preview">
                                            <button type="button" class="remove-image" onclick="deleteImage('question', {{ $oldAnswer->id }}, {{ $question->id }}, 'desktop')">
                                                 Remove image
                                            </button>
                                        </div>
                                    @endif
                                    @if($question->has_comment)
                                        <div class="comment-box">
                                            <textarea name="question[{{ $question->id }}][comment]"
                                                      placeholder="Add comment...">{{ $commentValue }}</textarea>
                                        </div>
                                    @endif
                                    @error("question.{$question->id}.image")
                                        <div class="error-message">{{ $message }}</div>
                                    @enderror
                                </div>
                            @endif

                            {{-- Sub Question List --}}
                            @if($question->type === 'subQuestionList')
                                @if($question->has_comment)
                                    <div class="comment-box" style="margin-bottom: 20px;">
                                        <textarea name="question[{{ $question->id }}][comment]"
                                                  placeholder="General comment for this section...">{{ $commentValue }}</textarea>
                                    </div>
                                @endif

                                @foreach($question->subQuestions as $subQuestion)
                                    @php
                                        $subOldAnswer = $subQuestionAnswers[$subQuestion->id] ?? null;
                                        $subAnswerValue = $subOldAnswer->answer_yes_no ?? old("subquestion.{$subQuestion->id}.answer_yes_no");
                                        $subCommentValue = $subOldAnswer->comment ?? old("subquestion.{$subQuestion->id}.comment");
                                        $subHasImage = !empty($subOldAnswer?->image_path);
                                    @endphp

                                    <div class="sub-question">
                                        <div class="sub-question-title">
                                            {{ $subQuestion->text }}
                                            @if($subQuestion->is_required)
                                                <span class="required-star">*</span>
                                            @endif
                                            @if($subQuestion->image_required_if_no)
                                                <span class="image-required-badge">Photo required if {{ $labels[1] }}</span>
                                            @endif
                                        </div>

                                        <div class="answer-options">
                                            <label class="answer-option">
                                                <input type="radio" name="subquestion[{{ $subQuestion->id }}][answer_yes_no]"
                                                       value="{{ $validValues[0] }}" {{ $subAnswerValue === $validValues[0] ? 'checked' : '' }}
                                                       data-subquestion-id="{{ $subQuestion->id }}" {{ $subQuestion->is_required ? 'required' : '' }}>
                                                <span>{{ $labels[0] }}</span>
                                            </label>
                                            <label class="answer-option">
                                                <input type="radio" name="subquestion[{{ $subQuestion->id }}][answer_yes_no]"
                                                       value="{{ $validValues[1] }}" {{ $subAnswerValue === $validValues[1] ? 'checked' : '' }}
                                                       data-subquestion-id="{{ $subQuestion->id }}" {{ $subQuestion->is_required ? 'required' : '' }}>
                                                <span>{{ $labels[1] }}</span>
                                            </label>
                                        </div>
                                        @error("subquestion.{$subQuestion->id}.answer_yes_no")
                                            <div class="error-message">{{ $message }}</div>
                                        @enderror

                                        {{-- COMMENT AUTOMATICALLY IF IS_REQUIRED = 1 --}}
                                        @if($subQuestion->is_required)
                                            <div class="comment-box" style="margin-top: 12px;">
                                                <label style="display: block; margin-bottom: 6px; color: #4b5563; font-size: 0.875rem; font-weight: 500;">
                                                    Comment (Required)
                                                </label>
                                                <textarea name="subquestion[{{ $subQuestion->id }}][comment]"
                                                          class="form-control @error("subquestion.{$subQuestion->id}.comment") is-invalid @enderror"
                                                          placeholder="Add comment (required)..."
                                                          required
                                                          style="width: 100%; padding: 12px; border: 1px solid #d1d5db; border-radius: 8px; resize: vertical; min-height: 80px; font-family: inherit; font-size: 0.95rem;">{{ $subCommentValue }}</textarea>
                                                @error("subquestion.{$subQuestion->id}.comment")
                                                    <div class="error-message">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        @endif

                                        {{-- IMAGE UPLOAD --}}
                                        @if($subQuestion->image_required_if_no)
                                            @php
                                                $subShowImage = in_array($subAnswerValue, ['no', 'bad']);
                                            @endphp
                                            <div class="image-upload" id="subimage-upload-{{ $subQuestion->id }}" style="{{ $subShowImage ? '' : 'display:none;' }}">
                                                <label>Upload Image (required if answer is {{ $labels[1] }}):</label>
                                                <input type="file" name="subquestion[{{ $subQuestion->id }}][image]"
                                                       accept="image/*" class="form-control sub-image-upload-input"
                                                       data-subquestion-id="{{ $subQuestion->id }}"
                                                       {{ $subShowImage && !$subHasImage ? 'required' : '' }}>
                                                @if($subHasImage)
                                                    <input type="hidden" name="subquestion[{{ $subQuestion->id }}][existing_image]"
                                                           value="{{ $subOldAnswer->image_path }}">
                                                    <div class="image-preview" id="subpreview-desktop-{{ $subQuestion->id }}">
                                                        <img src="{{ Storage::url($subOldAnswer->image_path) }}" alt="Preview">
                                                        <button type="button" class="remove-image" onclick="deleteImage('subquestion', {{ $subOldAnswer->id }}, {{ $subQuestion->id }}, 'desktop')">
                                                             Remove image
                                                        </button>
                                                    </div>
                                                @endif
                                                @error("subquestion.{$subQuestion->id}.image")
                                                    <div class="error-message">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        @endif
                                    </div>
                                @endforeach
                            @endif
                        @endif
                    </div>
                @endforeach

                {{-- OVERALL COMMENT (Only for Room Inspection at last step) --}}
                @if($checklist->mod_type === 'room_inspection' && $step + 1 >= $totalSteps)
                    <div class="overall-comment-card">
                        <h3>Overall Comment for this Room</h3>
                        <p style="color: #6b7280; margin-bottom: 16px; font-size: 0.95rem;">
                            Please provide an overall comment for this room inspection.
                        </p>
                        <div class="comment-box">
                            <label style="display: block; margin-bottom: 8px; color: #4b5563; font-weight: 500;">
                                Overall Comment <span class="required-star">*</span>
                            </label>
                            <textarea name="overall_comment"
                                      class="overall-comment-textarea @error('overall_comment') is-invalid @enderror"
                                      required
                                      placeholder="Write overall comment for this room..."
                                      minlength="10"
                                      rows="4">{{ old('overall_comment', $submission->overall_comment ?? '') }}</textarea>
                            <small class="text-muted" style="color: #6b7280; font-size: 0.875rem; display: block; margin-top: 6px;">
                                Minimum 10 characters
                            </small>
                            @error('overall_comment')
                                <div class="error-message">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                @endif
            @else
                <div class="no-questions">
                    <p style="font-size: 16px; color: #6b7280;">No questions in this section.</p>
                    <p style="font-size: 14px; color: #9ca3af;">Please continue to the next section.</p>
                </div>
            @endif

            {{-- Navigation Desktop --}}
            <div class="navigation-desktop">
                @if($step > 0)
                    <a href="{{ route('user.checklist.fill', ['checklistId' => $checklist->id, 'step' => $step - 1]) }}"
                       data-confirm-exit
                       class="btn-desktop btn-prev">
                         <i class="fas fa-arrow-left"></i>Previous
                    </a>
                @else
                    <div></div>
                @endif

                {{-- Dynamic Button Text --}}
                @if($step + 1 >= $totalSteps)
                    @if($checklist->mod_type === 'room_inspection')
                        @php
                            $isLastRoom = $roomCount >= 4;
                            $remainingRooms = 4 - $roomCount;
                        @endphp
                        @if($isLastRoom)
                            <button type="submit" class="btn-desktop btn-submit" onclick="return confirm('This is the last room (5/5). After submitting, the Room Inspection category will be completed. Continue?')">
                                 Finish Category
                            </button>
                        @else
                            <button type="submit" class="btn-desktop btn-primary-custom">
                                Save & Add New Room ({{ $remainingRooms }} remaining)
                            </button>
                        @endif
                    @else
                        <button type="submit" class="btn-desktop btn-submit">
                             Submit Checklist
                        </button>
                    @endif
                @else
                    <button type="submit" class="btn-desktop btn-next">
                        Save & Continue <i class="fas fa-arrow-right"></i>
                    </button>
                @endif

                {{-- Auto-save Status --}}
                <div class="auto-save-status" id="autoSaveStatus">
                    Progress saved automatically every 30 seconds
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

{{-- ================= MOBILE VERSION ================= --}}
@section('mobile-content')
{{-- Submission metadata for JavaScript --}}
<meta name="submission-id" content="{{ $submission->id }}">
<meta name="reset-progress-url" content="{{ route('user.checklist.reset-progress', ['submissionId' => $submission->id]) }}">
<meta name="redirect-url" content="{{ route('user.dashboard') }}">
<meta name="csrf-token" content="{{ csrf_token() }}">

<div class="mobile-container">
    {{-- Exit Confirmation Modal --}}
    <div id="exitModalMobile" class="exit-confirmation-modal">
        <div class="modal-content">
            <h3 class="modal-title">Unsaved Changes</h3>
            <p class="modal-message">Your progress has not been saved automatically yet. Are you sure you want to leave? All unsaved data will be lost.</p>
            <div class="modal-buttons">
                <button id="cancelExitMobile" class="modal-btn modal-btn-cancel">Cancel</button>
                <button id="confirmExitMobile" class="modal-btn modal-btn-confirm">Leave Without Saving</button>
            </div>
        </div>
    </div>

    {{-- Success/Error Messages --}}
    @if(session('success'))
        <div class="success-message" style="margin: 16px; border-radius: 10px;">
            {{ session('success') }}
        </div>
    @endif
    @if(session('error'))
        <div class="alert-message" style="margin: 16px; border-radius: 10px;">
            {{ session('error') }}
        </div>
    @endif

    {{-- Mobile Form --}}
    <div class="form-mobile">
        <form method="POST"
              action="{{ route('user.checklist.save', ['checklistId' => $checklist->id, 'step' => $step]) }}"
              enctype="multipart/form-data"
              id="checklistFormMobile">
            @csrf

            @if(isset($isResume) && $isResume)
                <input type="hidden" name="is_resume" value="1">
            @endif

            {{-- ROOM INSPECTION HEADER MOBILE --}}
            @if($checklist->mod_type === 'room_inspection')
                <div class="room-inspection-header-mobile">
                    <h1>{{ $checklist->hotel }} - Room Inspection ({{ $roomCount + 1 }}/5)</h1>
                    
                    @if($step == 0)
                        <div style="margin-bottom: 16px;">
                            <div style="font-size: 1rem; color: #4b5563; margin-bottom: 10px;">
                                Please enter room number for room {{ $roomCount + 1 }}:
                            </div>
                            <input type="text"
                                   name="room_number"
                                   id="room_number_mobile"
                                   value="{{ old('room_number', $roomNumber ?? '') }}"
                                   placeholder="Room no"
                                   class="room-number-input-mobile"
                                   required>
                            @error('room_number')
                                <div class="error-message" style="margin-top: 10px;">{{ $message }}</div>
                            @enderror
                        </div>
                    @else
                        <div style="margin-bottom: 16px;">
                            <div style="font-size: 1rem; color: #4b5563; margin-bottom: 8px;">
                                Room {{ $roomCount + 1 }} - Room Number:
                            </div>
                            <div class="room-number-display-mobile">
                                <strong>{{ $roomNumber ?? 'Not entered' }}</strong>
                            </div>
                            <input type="hidden" name="room_number" value="{{ $roomNumber }}">
                        </div>
                    @endif

                    <div class="room-progress-indicator-mobile">
                        <span style="font-weight: 600;">Progress:</span>
                        <span style="margin-left: 6px; color: #1f2937; font-weight: 700;">
                            Room {{ $roomCount + 1 }}/5 - Section {{ $step + 1 }}/{{ $totalSteps }}
                        </span>
                    </div>
                </div>
            @endif

            {{-- Questions Mobile --}}
            @if($questions->count() > 0)
                @foreach($questions as $question)
                    @php
                        $oldAnswer = $questionAnswers[$question->id] ?? null;
                        $answerValue = $oldAnswer->answer_yes_no ?? old("question.{$question->id}.answer_yes_no");
                        $commentValue = $oldAnswer->comment ?? old("question.{$question->id}.comment");
                        $hasImage = !empty($oldAnswer?->image_path);
                        $validValues = ($checklist->mod_type === 'room_inspection') ? ['good', 'bad'] : ['yes', 'no'];
                        $labels = ($checklist->mod_type === 'room_inspection') ? ['Good', 'Bad'] : ['Yes', 'No'];
                    @endphp

                    <div class="question-card-mobile" id="question-mobile-{{ $question->id }}">
                        {{-- Header Type --}}
                        @if($question->type === 'header')
                            <div class="section-header" style="margin: 0 0 12px 0; padding: 16px; font-size: 1rem;">
                                {{ $question->question_text }}
                            </div>
                        @elseif($question->type === 'readOnlyText')
                            <div class="readonly-text" style="margin: 0 0 12px 0; padding: 16px; font-size: 0.9rem;">
                                {{ $question->question_text }}
                            </div>
                        @elseif($question->type === 'pageNote')
                            <div class="page-note" style="margin: 0 0 12px 0; padding: 16px; font-size: 0.9rem;">
                                 {{ $question->question_text }}
                            </div>
                        @else
                            <div class="question-title-mobile">
                                {{ $question->question_text }}
                                @if($question->is_required && !in_array($question->type, ['header', 'readOnlyText', 'pageNote']))
                                    <span class="required-star">*</span>
                                @endif
                                @if($question->image_required_if_no)
                                    <div style="margin-top: 4px;">
                                        <span class="image-required-badge">Photo required if {{ $labels[1] }}</span>
                                    </div>
                                @endif
                            </div>

                            {{-- Yes/No Question --}}
                            @if($question->type === 'yesNo')
                                <div class="answer-options">
                                    <label class="answer-option" style="flex: 1;">
                                        <input type="radio" name="question[{{ $question->id }}][answer_yes_no]"
                                               value="{{ $validValues[0] }}" {{ $answerValue === $validValues[0] ? 'checked' : '' }}
                                               data-question-id="{{ $question->id }}" {{ $question->is_required ? 'required' : '' }}>
                                        <span>{{ $labels[0] }}</span>
                                    </label>
                                    <label class="answer-option" style="flex: 1;">
                                        <input type="radio" name="question[{{ $question->id }}][answer_yes_no]"
                                               value="{{ $validValues[1] }}" {{ $answerValue === $validValues[1] ? 'checked' : '' }}
                                               data-question-id="{{ $question->id }}" {{ $question->is_required ? 'required' : '' }}>
                                        <span>{{ $labels[1] }}</span>
                                    </label>
                                </div>
                                @error("question.{$question->id}.answer_yes_no")
                                    <div class="error-message">{{ $message }}</div>
                                @enderror

                                @if($question->has_comment)
                                    <div class="comment-box">
                                        <textarea name="question[{{ $question->id }}][comment]"
                                                  placeholder="Add comment...">{{ $commentValue }}</textarea>
                                        @error("question.{$question->id}.comment")
                                            <div class="error-message">{{ $message }}</div>
                                        @enderror
                                    </div>
                                @endif

                                @if($question->image_required_if_no)
                                    @php
                                        $showImageUpload = in_array($answerValue, ['no', 'bad']);
                                    @endphp
                                    <div class="image-upload" id="image-upload-mobile-{{ $question->id }}" style="{{ $showImageUpload ? '' : 'display:none;' }}">
                                        <label>Upload Image (required if answer is {{ $labels[1] }}):</label>
                                        <input type="file" name="question[{{ $question->id }}][image]"
                                               accept="image/*" class="form-control image-upload-input"
                                               data-question-id="{{ $question->id }}"
                                               {{ $showImageUpload && !$hasImage ? 'required' : '' }}>
                                        @if($hasImage)
                                            <input type="hidden" name="question[{{ $question->id }}][existing_image]"
                                                   value="{{ $oldAnswer->image_path }}">
                                            <div class="image-preview" id="preview-mobile-{{ $question->id }}">
                                                <img src="{{ Storage::url($oldAnswer->image_path) }}" alt="Preview">
                                                <button type="button" class="remove-image" onclick="deleteImage('question', {{ $oldAnswer->id }}, {{ $question->id }}, 'mobile')">
                                                     Remove
                                                </button>
                                            </div>
                                        @endif
                                        @error("question.{$question->id}.image")
                                            <div class="error-message">{{ $message }}</div>
                                        @enderror
                                    </div>
                                @endif
                            @endif

                            {{-- Image Upload Only --}}
                            @if($question->type === 'imageUpload')
                                <div class="image-upload">
                                    <label>Upload Image:</label>
                                    <input type="file" name="question[{{ $question->id }}][image]"
                                           accept="image/*" class="form-control image-upload-input"
                                           data-question-id="{{ $question->id }}"
                                           {{ $question->is_required && !$hasImage ? 'required' : '' }}>
                                    @if($hasImage)
                                        <input type="hidden" name="question[{{ $question->id }}][existing_image]"
                                               value="{{ $oldAnswer->image_path }}">
                                        <div class="image-preview" id="preview-mobile-{{ $question->id }}">
                                            <img src="{{ Storage::url($oldAnswer->image_path) }}" alt="Preview">
                                            <button type="button" class="remove-image" onclick="deleteImage('question', {{ $oldAnswer->id }}, {{ $question->id }}, 'mobile')">
                                                 Remove
                                            </button>
                                        </div>
                                    @endif
                                    @if($question->has_comment)
                                        <div class="comment-box">
                                            <textarea name="question[{{ $question->id }}][comment]"
                                                      placeholder="Comment...">{{ $commentValue }}</textarea>
                                        </div>
                                    @endif
                                    @error("question.{$question->id}.image")
                                        <div class="error-message">{{ $message }}</div>
                                    @enderror
                                </div>
                            @endif

                            {{-- Sub Question List --}}
                            @if($question->type === 'subQuestionList')
                                @if($question->has_comment)
                                    <div class="comment-box" style="margin-bottom: 16px;">
                                        <textarea name="question[{{ $question->id }}][comment]"
                                                  placeholder="General comment...">{{ $commentValue }}</textarea>
                                    </div>
                                @endif

                                @foreach($question->subQuestions as $subQuestion)
                                    @php
                                        $subOldAnswer = $subQuestionAnswers[$subQuestion->id] ?? null;
                                        $subAnswerValue = $subOldAnswer->answer_yes_no ?? old("subquestion.{$subQuestion->id}.answer_yes_no");
                                        $subCommentValue = $subOldAnswer->comment ?? old("subquestion.{$subQuestion->id}.comment");
                                        $subHasImage = !empty($subOldAnswer?->image_path);
                                    @endphp

                                    <div class="sub-question">
                                        <div class="sub-question-title">
                                            {{ $subQuestion->text }}
                                            @if($subQuestion->is_required)
                                                <span class="required-star">*</span>
                                            @endif
                                            @if($subQuestion->image_required_if_no)
                                                <div style="margin-top: 4px;">
                                                    <span class="image-required-badge">Photo required if {{ $labels[1] }}</span>
                                                </div>
                                            @endif
                                        </div>

                                        <div class="answer-options">
                                            <label class="answer-option" style="flex: 1;">
                                                <input type="radio" name="subquestion[{{ $subQuestion->id }}][answer_yes_no]"
                                                       value="{{ $validValues[0] }}" {{ $subAnswerValue === $validValues[0] ? 'checked' : '' }}
                                                       data-subquestion-id="{{ $subQuestion->id }}" {{ $subQuestion->is_required ? 'required' : '' }}>
                                                <span>{{ $labels[0] }}</span>
                                            </label>
                                            <label class="answer-option" style="flex: 1;">
                                                <input type="radio" name="subquestion[{{ $subQuestion->id }}][answer_yes_no]"
                                                       value="{{ $validValues[1] }}" {{ $subAnswerValue === $validValues[1] ? 'checked' : '' }}
                                                       data-subquestion-id="{{ $subQuestion->id }}" {{ $subQuestion->is_required ? 'required' : '' }}>
                                                <span>{{ $labels[1] }}</span>
                                            </label>
                                        </div>
                                        @error("subquestion.{$subQuestion->id}.answer_yes_no")
                                            <div class="error-message">{{ $message }}</div>
                                        @enderror

                                        @if($subQuestion->is_required)
                                            <div class="comment-box" style="margin-top: 10px;">
                                                <label style="display: block; margin-bottom: 6px; color: #4b5563; font-size: 0.85rem; font-weight: 500;">
                                                    Comment *
                                                </label>
                                                <textarea name="subquestion[{{ $subQuestion->id }}][comment]"
                                                          class="form-control @error("subquestion.{$subQuestion->id}.comment") is-invalid @enderror"
                                                          placeholder="Required..."
                                                          required
                                                          style="width: 100%; padding: 10px; border: 1px solid #d1d5db; border-radius: 8px; resize: vertical; min-height: 70px; font-size: 0.9rem;">{{ $subCommentValue }}</textarea>
                                                @error("subquestion.{$subQuestion->id}.comment")
                                                    <div class="error-message">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        @endif

                                        @if($subQuestion->image_required_if_no)
                                            @php
                                                $subShowImage = in_array($subAnswerValue, ['no', 'bad']);
                                            @endphp
                                            <div class="image-upload" id="subimage-upload-mobile-{{ $subQuestion->id }}" style="{{ $subShowImage ? '' : 'display:none;' }}">
                                                <label>Upload Image (required if {{ $labels[1] }}):</label>
                                                <input type="file" name="subquestion[{{ $subQuestion->id }}][image]"
                                                       accept="image/*" class="form-control sub-image-upload-input"
                                                       data-subquestion-id="{{ $subQuestion->id }}"
                                                       {{ $subShowImage && !$subHasImage ? 'required' : '' }}>
                                                @if($subHasImage)
                                                    <input type="hidden" name="subquestion[{{ $subQuestion->id }}][existing_image]"
                                                           value="{{ $subOldAnswer->image_path }}">
                                                    <div class="image-preview" id="subpreview-mobile-{{ $subQuestion->id }}">
                                                        <img src="{{ Storage::url($subOldAnswer->image_path) }}" alt="Preview">
                                                        <button type="button" class="remove-image" onclick="deleteImage('subquestion', {{ $subOldAnswer->id }}, {{ $subQuestion->id }}, 'mobile')">
                                                             Remove
                                                        </button>
                                                    </div>
                                                @endif
                                                @error("subquestion.{$subQuestion->id}.image")
                                                    <div class="error-message">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        @endif
                                    </div>
                                @endforeach
                            @endif
                        @endif
                    </div>
                @endforeach

                {{-- OVERALL COMMENT (Only for Room Inspection at last step) --}}
                @if($checklist->mod_type === 'room_inspection' && $step + 1 >= $totalSteps)
                    <div class="overall-comment-card" style="margin: 16px; padding: 20px; border-radius: 12px;">
                        <h3 style="font-size: 1.1rem; margin-bottom: 12px;">Overall Comment for this Room</h3>
                        <div class="comment-box">
                            <label style="display: block; margin-bottom: 8px; color: #4b5563; font-weight: 500; font-size: 0.9rem;">
                                Overall Comment <span class="required-star">*</span>
                            </label>
                            <textarea name="overall_comment"
                                      class="overall-comment-textarea @error('overall_comment') is-invalid @enderror"
                                      required
                                      style="min-height: 100px;"
                                      placeholder="Write overall comment for this room...">{{ old('overall_comment', $submission->overall_comment ?? '') }}</textarea>
                            <small class="text-muted" style="color: #6b7280; font-size: 0.75rem; display: block; margin-top: 4px;">
                                Minimum 10 characters
                            </small>
                            @error('overall_comment')
                                <div class="error-message">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                @endif
            @else
                <div class="no-questions" style="margin: 20px 0; padding: 32px 16px;">
                    <p style="font-size: 16px; color: #6b7280;">No questions in this section.</p>
                    <p style="font-size: 14px; color: #9ca3af;">Please continue to the next section.</p>
                </div>
            @endif

            {{-- Navigation Mobile --}}
            <div class="navigation-mobile">
                @if($step > 0)
                    <a href="{{ route('user.checklist.fill', ['checklistId' => $checklist->id, 'step' => $step - 1]) }}"
                       data-confirm-exit
                       class="btn-mobile btn-prev">
                         <i class="fas fa-arrow-left"></i>Previous
                    </a>
                @else
                    <div style="flex: 1;"></div>
                @endif

                @if($step + 1 >= $totalSteps)
                    @if($checklist->mod_type === 'room_inspection')
                        @php
                            $isLastRoom = $roomCount >= 4;
                            $remainingRooms = 4 - $roomCount;
                        @endphp
                        @if($isLastRoom)
                            <button type="submit" class="btn-mobile btn-submit" onclick="return confirm('This is the last room (5/5). After submitting, the Room Inspection category will be completed. Continue?')">
                                 Finish Category
                            </button>
                        @else
                            <button type="submit" class="btn-mobile btn-primary-custom">
                                 New Room ({{ $remainingRooms }} remaining)
                            </button>
                        @endif
                    @else
                        <button type="submit" class="btn-mobile btn-submit">
                             Submit Checklist
                        </button>
                    @endif
                @else
                    <button type="submit" class="btn-mobile btn-next">
                         Continue <i class="fas fa-arrow-right"></i>
                    </button>
                @endif

                {{-- Auto-save Status (Mobile) --}}
                <div class="auto-save-status" id="autoSaveStatusMobile" style="position: absolute; top: -30px; left: 0; right: 0; text-align: center; display: none;">
                     Saved
                </div>
            </div>
        </form>
    </div>
</div>
</div>
@endsection

@push('scripts')
<script>
// ============================================
// GLOBAL ERROR HANDLING
// ============================================
window.onerror = function(msg, url, lineNo, columnNo, error) {
    console.error('Error: ' + msg + '\nURL: ' + url + '\nLine: ' + lineNo + '\nColumn: ' + columnNo + '\nError object: ' + JSON.stringify(error));
    return false;
};

// ============================================
// GLOBAL VARIABLES
// ============================================
let isFormDirty = false;
let exitConfirmed = false;
let targetUrl = null;
let submissionId = {{ $submission->id }};
let isResetting = false;
let autoSaveTimer = null;
const AUTO_SAVE_INTERVAL = 30000; // 30 seconds

// ============================================
// TRACK FORM CHANGES
// ============================================
function trackFormChanges() {
    const forms = document.querySelectorAll('form[id^="checklistForm"]');
    forms.forEach(form => {
        // Input events
        form.addEventListener('input', function(e) {
            if (!e.target.matches('button, [type="submit"], [type="file"]')) {
                isFormDirty = true;
            }
        });
        // Change events
        form.addEventListener('change', function() {
            isFormDirty = true;
        });
    });
}

// ============================================
// AUTO-SAVE FUNCTIONALITY
// ============================================
function triggerAutoSave() {
    if (!isFormDirty) return;

    const form = document.querySelector('form[id^="checklistForm"]');
    if (!form) return;

    const formData = new FormData(form);
    const checklistId = '{{ $checklist->id }}';
    const step = {{ $step }};

    fetch('{{ route("user.checklist.auto-save", ["checklistId" => $checklist->id, "step" => $step]) }}', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
            'Accept': 'application/json'
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            isFormDirty = false;
            updateAutoSaveStatus(`Saved automatically • ${data.last_saved}`);
            
            // Show brief success indicator on mobile
            const mobileStatus = document.getElementById('autoSaveStatusMobile');
            if (mobileStatus) {
                mobileStatus.style.display = 'block';
                mobileStatus.classList.add('saved');
                setTimeout(() => {
                    mobileStatus.style.display = 'none';
                    mobileStatus.classList.remove('saved');
                }, 2000);
            }
        }
    })
    .catch(error => {
        console.error('Auto-save failed:', error);
        updateAutoSaveStatus('⚠️ Save failed', true);
    });
}

function updateAutoSaveStatus(message, isError = false) {
    const statusEl = document.getElementById('autoSaveStatus');
    if (statusEl) {
        statusEl.textContent = message;
        statusEl.style.color = isError ? '#ef4444' : '#6b7280';
        if (!isError) {
            statusEl.classList.add('saved');
        } else {
            statusEl.classList.remove('saved');
        }
    }
}

// ============================================
// SHOW EXIT CONFIRMATION MODAL
// ============================================
function showExitConfirmation(url = null) {
    if (exitConfirmed || !isFormDirty || isResetting) {
        if (url) {
            window.location.href = url;
        }
        return true;
    }
    targetUrl = url;
    
    // Determine which modal to show based on screen size
    const isMobile = window.innerWidth <= 768;
    const modal = isMobile ? document.getElementById('exitModalMobile') : document.getElementById('exitModal');
    if (modal) {
        modal.style.display = 'flex';
        document.body.style.overflow = 'hidden'; // Prevent background scroll
    }
    return false;
}

// ============================================
// SETUP NAVIGATION INTERCEPTORS
// ============================================
function setupNavigationInterceptors() {
    // Intercept all anchor links
    document.querySelectorAll('a[href]').forEach(link => {
        link.addEventListener('click', function(e) {
            const href = this.getAttribute('href');
            // Skip special links
            if (!href ||
                href.startsWith('#') ||
                href.startsWith('javascript:') ||
                href.startsWith('mailto:') ||
                href.startsWith('tel:') ||
                href.includes('delete-image') ||
                href === window.location.href ||
                href === window.location.pathname) {
                return;
            }
            e.preventDefault();
            if (showExitConfirmation(href)) {
                window.location.href = href;
            }
        });
    });

    // Intercept previous step buttons
    document.querySelectorAll('.btn-prev').forEach(btn => {
        btn.addEventListener('click', function(e) {
            e.preventDefault();
            const href = this.getAttribute('href');
            showExitConfirmation(href);
        });
    });

    // Intercept browser back button
    window.addEventListener('popstate', function(e) {
        if (isFormDirty && !exitConfirmed && !isResetting) {
            e.preventDefault();
            history.pushState(null, null, location.href);
            showExitConfirmation();
        }
    });

    // Intercept beforeunload (browser close/tab close)
    window.addEventListener('beforeunload', function(e) {
        if (isFormDirty && !exitConfirmed && !isResetting) {
            e.preventDefault();
            e.returnValue = 'Your progress has not been saved automatically yet. Are you sure you want to leave?';
            return e.returnValue;
        }
    });
}

// ============================================
// RESET PROGRESS FROM DATABASE
// ============================================
function resetProgressAndRedirect(redirectUrl) {
    if (isResetting) return;
    isResetting = true;

    // Show loading state
    document.querySelectorAll('.modal-btn-confirm').forEach(btn => {
        btn.disabled = true;
        btn.innerHTML = 'Deleting...';
    });

    fetch('{{ route("user.checklist.reset-progress", ["submissionId" => $submission->id]) }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: JSON.stringify({
            submission_id: submissionId
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            exitConfirmed = true;
            // Hide modal
            const modal = document.getElementById('exitModal') || document.getElementById('exitModalMobile');
            if (modal) {
                modal.style.display = 'none';
                document.body.style.overflow = 'auto';
            }
            // Redirect
            window.location.href = redirectUrl || '{{ route("user.dashboard") }}';
        } else {
            alert('Failed to delete progress: ' + (data.message || 'An error occurred'));
            isResetting = false;
            document.querySelectorAll('.modal-btn-confirm').forEach(btn => {
                btn.disabled = false;
                btn.innerHTML = 'Leave Without Saving';
            });
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('An error occurred: ' + error.message);
        isResetting = false;
        document.querySelectorAll('.modal-btn-confirm').forEach(btn => {
            btn.disabled = false;
            btn.innerHTML = 'Leave Without Saving';
        });
    });
}

// ============================================
// SETUP MODAL BUTTONS
// ============================================
function setupModalButtons() {
    // Desktop Cancel
    document.getElementById('cancelExit')?.addEventListener('click', function() {
        document.getElementById('exitModal').style.display = 'none';
        document.body.style.overflow = 'auto';
        targetUrl = null;
    });

    // Mobile Cancel
    document.getElementById('cancelExitMobile')?.addEventListener('click', function() {
        document.getElementById('exitModalMobile').style.display = 'none';
        document.body.style.overflow = 'auto';
        targetUrl = null;
    });

    // Desktop Confirm
    document.getElementById('confirmExit')?.addEventListener('click', function() {
        const redirectUrl = targetUrl || '{{ route("user.dashboard") }}';
        resetProgressAndRedirect(redirectUrl);
    });

    // Mobile Confirm
    document.getElementById('confirmExitMobile')?.addEventListener('click', function() {
        const redirectUrl = targetUrl || '{{ route("user.dashboard") }}';
        resetProgressAndRedirect(redirectUrl);
    });
}

// ============================================
// SETUP ANSWER LISTENERS
// ============================================
function setupAnswerListeners() {
    document.querySelectorAll('input[name$="[answer_yes_no]"]').forEach(radio => {
        radio.addEventListener('change', function() {
            const name = this.name;
            const value = this.value;
            const questionIdMatch = name.match(/\[(\d+)\]/);
            if (!questionIdMatch) return;
            const questionId = questionIdMatch[1];
            const isSubQuestion = name.includes('subquestion');
            const prefix = isSubQuestion ? 'sub' : '';
            const isRoomInspection = '{{ $checklist->mod_type }}' === 'room_inspection';
            const badValue = isRoomInspection ? 'bad' : 'no';

            // Determine version (desktop/mobile)
            const isMobile = window.innerWidth <= 768;
            const versionPrefix = isMobile ? 'mobile-' : '';

            // Show/hide image upload
            let imageUploadDiv = document.getElementById(`${prefix}image-upload-${versionPrefix}${questionId}`);
            // Try without version prefix if not found
            if (!imageUploadDiv && versionPrefix) {
                imageUploadDiv = document.getElementById(`${prefix}image-upload-${questionId}`);
            }

            if (imageUploadDiv) {
                if (value === badValue) {
                    imageUploadDiv.style.display = 'block';
                    // Mark file input as required if showing
                    const fileInput = imageUploadDiv.querySelector('input[type="file"]');
                    if (fileInput) {
                        const existingImage = imageUploadDiv.querySelector('input[type="hidden"][name*="existing_image"]');
                        if (!existingImage || !existingImage.value) {
                            fileInput.required = true;
                        }
                    }
                } else {
                    imageUploadDiv.style.display = 'none';
                    // Remove required attribute when hiding
                    const fileInput = imageUploadDiv.querySelector('input[type="file"]');
                    if (fileInput) {
                        fileInput.required = false;
                    }
                }
            }
            isFormDirty = true;
        });
    });
}

// ============================================
// SETUP IMAGE PREVIEW
// ============================================
function setupImagePreview(containerId) {
    const container = document.getElementById(containerId);
    if (!container) return;

    container.querySelectorAll('.image-upload-input, .sub-image-upload-input').forEach(input => {
        input.addEventListener('change', function(e) {
            isFormDirty = true;
            const file = e.target.files[0];
            const questionId = this.dataset.questionId || this.dataset.subquestionId;
            // Determine if this is sub-question
            const isSub = this.classList.contains('sub-image-upload-input');
            const type = isSub ? 'subquestion' : 'question';
            // Determine version (desktop/mobile) based on containerId
            const version = containerId.includes('Mobile') ? 'mobile' : 'desktop';

            if (file) {
                // Validate file size and type
                if (file.size > 5 * 1024 * 1024) {
                    alert('Maximum file size is 5MB');
                    this.value = '';
                    return;
                }
                if (!file.type.startsWith('image/')) {
                    alert('Only image files are allowed');
                    this.value = '';
                    return;
                }

                const reader = new FileReader();
                reader.onload = function(e) {
                    // Remove old preview if exists
                    const oldPreview = document.getElementById(`${type === 'question' ? 'preview' : 'subpreview'}-${version}-${questionId}`);
                    if (oldPreview) {
                        oldPreview.remove();
                    }

                    // Create new preview element
                    const previewDiv = document.createElement('div');
                    previewDiv.className = 'image-preview';
                    previewDiv.id = `${type === 'question' ? 'preview' : 'subpreview'}-${version}-${questionId}`;

                    const img = document.createElement('img');
                    img.src = e.target.result;
                    img.alt = 'Preview';

                    const removeBtn = document.createElement('button');
                    removeBtn.type = 'button';
                    removeBtn.className = 'remove-image';
                    removeBtn.textContent = '🗑️ Remove image';
                    removeBtn.onclick = function() {
                        previewDiv.remove();
                        input.value = '';
                        input.required = false;
                        isFormDirty = true;
                    };

                    previewDiv.appendChild(img);
                    previewDiv.appendChild(removeBtn);
                    input.parentNode.appendChild(previewDiv);
                };
                reader.readAsDataURL(file);
            }
        });
    });
}

// ============================================
// SETUP FORM VALIDATION
// ============================================
function setupFormValidation(formId) {
    const form = document.getElementById(formId);
    if (!form) return;

    form.addEventListener('submit', function(e) {
        let isValid = true;

        // Reset error messages
        form.querySelectorAll('.error-message').forEach(el => {
            if (el.id !== 'system-error') el.remove();
        });

        // Validate required radio buttons
        form.querySelectorAll('input[type="radio"][required]').forEach(radio => {
            const name = radio.name;
            const group = form.querySelectorAll(`input[name="${name}"]`);
            const isChecked = Array.from(group).some(r => r.checked);
            if (!isChecked) {
                isValid = false;
                const questionId = name.match(/\[(\d+)\]/)?.[1];
                if (questionId) {
                    const version = formId.includes('Desktop') ? 'desktop' : 'mobile';
                    const card = document.querySelector(`#question-${version}-${questionId}`);
                    if (card && !card.querySelector('.error-message')) {
                        const errorDiv = document.createElement('div');
                        errorDiv.className = 'error-message';
                        errorDiv.textContent = 'This question is required';
                        const answerOptions = card.querySelector('.answer-options');
                        if (answerOptions) {
                            answerOptions.after(errorDiv);
                        }
                    }
                }
            }
        });

        // Validate required textareas
        form.querySelectorAll('textarea[required]').forEach(textarea => {
            if (!textarea.value.trim()) {
                isValid = false;
                if (!textarea.nextElementSibling?.classList?.contains('error-message')) {
                    const errorDiv = document.createElement('div');
                    errorDiv.className = 'error-message';
                    errorDiv.textContent = 'Comment is required';
                    textarea.parentNode.insertBefore(errorDiv, textarea.nextSibling);
                }
            }
        });

        // Validate overall comment
        const overallComment = form.querySelector('textarea[name="overall_comment"]');
        if (overallComment && overallComment.required && !overallComment.value.trim()) {
            isValid = false;
            if (!overallComment.nextElementSibling?.classList?.contains('error-message')) {
                const errorDiv = document.createElement('div');
                errorDiv.className = 'error-message';
                errorDiv.textContent = 'Overall comment is required (minimum 10 characters)';
                overallComment.parentNode.insertBefore(errorDiv, overallComment.nextSibling);
            }
        } else if (overallComment && overallComment.value.trim().length < 10) {
            isValid = false;
            if (!overallComment.nextElementSibling?.classList?.contains('error-message')) {
                const errorDiv = document.createElement('div');
                errorDiv.className = 'error-message';
                errorDiv.textContent = 'Overall comment must be at least 10 characters';
                overallComment.parentNode.insertBefore(errorDiv, overallComment.nextSibling);
            }
        }

        // Validate image uploads for "Bad" answers
        if ('{{ $checklist->mod_type }}' === 'room_inspection') {
            form.querySelectorAll('input[type="radio"][value="bad"]:checked').forEach(radio => {
                const name = radio.name;
                const questionId = name.match(/\[(\d+)\]/)?.[1];
                const isSubQuestion = name.includes('subquestion');
                const prefix = isSubQuestion ? 'sub' : '';
                const version = formId.includes('Desktop') ? 'desktop' : 'mobile';
                const imageUploadDiv = document.getElementById(`${prefix}image-upload-${version}-${questionId}`);
                
                if (imageUploadDiv && imageUploadDiv.style.display !== 'none') {
                    const fileInput = imageUploadDiv.querySelector('input[type="file"]');
                    const existingImage = imageUploadDiv.querySelector('input[type="hidden"][name*="existing_image"]');
                    if (fileInput && !fileInput.value && (!existingImage || !existingImage.value)) {
                        isValid = false;
                        // Add error message
                        if (!imageUploadDiv.querySelector('.error-message')) {
                            const errorDiv = document.createElement('div');
                            errorDiv.className = 'error-message';
                            errorDiv.textContent = 'Photo is required for "Bad" answer';
                            imageUploadDiv.appendChild(errorDiv);
                        }
                    }
                }
            });
        }

        if (!isValid) {
            e.preventDefault();
            const firstError = form.querySelector('.error-message');
            if (firstError) {
                firstError.scrollIntoView({ behavior: 'smooth', block: 'center' });
            }
            alert('Please complete all required fields before continuing.');
        } else {
            isFormDirty = false;
        }
    });
}

// ============================================
// DELETE IMAGE FUNCTION
// ============================================
function deleteImage(type, answerId, questionId, version = 'desktop') {
    if (!confirm('Are you sure you want to delete this image?')) {
        return;
    }

    fetch('{{ route("user.checklist.delete-image") }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: JSON.stringify({
            type: type,
            id: answerId
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            const previewId = type === 'question'
                ? `preview-${version}-${questionId}`
                : `subpreview-${version}-${questionId}`;
            const previewElement = document.getElementById(previewId);
            if (previewElement) {
                previewElement.remove();
            }

            const hiddenInput = document.querySelector(`input[name="${type}[${questionId}][existing_image]"]`);
            if (hiddenInput) {
                hiddenInput.remove();
            }

            const fileInput = document.querySelector(`input[name="${type}[${questionId}][image]"]`);
            if (fileInput) {
                fileInput.value = '';
                fileInput.required = false;
            }

            alert('Image deleted successfully');
            isFormDirty = true;
        } else {
            alert('Failed to delete image: ' + data.message);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('An error occurred while deleting the image');
    });
}

// ============================================
// ROOM NUMBER VALIDATION
// ============================================
function setupRoomNumberValidation() {
    const roomNumberInput = document.getElementById('room_number');
    const roomNumberInputMobile = document.getElementById('room_number_mobile');

    if (roomNumberInput) {
        roomNumberInput.addEventListener('blur', function() {
            validateRoomNumber(this.value);
        });
    }

    if (roomNumberInputMobile) {
        roomNumberInputMobile.addEventListener('blur', function() {
            validateRoomNumber(this.value);
        });
    }
}

function validateRoomNumber(roomNumber) {
    if (!roomNumber.trim()) return;

    fetch('{{ route("user.checklist.validate-room-number") }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: JSON.stringify({
            room_number: roomNumber,
            current_submission_id: {{ $submission->id ?? 0 }}
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.exists) {
            alert('This room number has already been used for inspection today.');
        }
    })
    .catch(error => {
        console.error('Error:', error);
    });
}

// ============================================
// INITIALIZE ON DOM LOAD
// ============================================
document.addEventListener('DOMContentLoaded', function() {
    // Ensure CSRF token meta exists
    if (!document.querySelector('meta[name="csrf-token"]')) {
        const csrfToken = '{{ csrf_token() }}';
        const meta = document.createElement('meta');
        meta.name = 'csrf-token';
        meta.content = csrfToken;
        document.head.appendChild(meta);
    }

    // Setup all functionality
    trackFormChanges();
    setupNavigationInterceptors();
    setupModalButtons();
    setupAnswerListeners();
    setupImagePreview('checklistFormDesktop');
    setupImagePreview('checklistFormMobile');
    setupFormValidation('checklistFormDesktop');
    setupFormValidation('checklistFormMobile');
    setupRoomNumberValidation();

    // Start auto-save timer
    autoSaveTimer = setInterval(triggerAutoSave, AUTO_SAVE_INTERVAL);
    
    // Force save when window loses focus (switch tab/app)
    window.addEventListener('blur', triggerAutoSave);
    
    // Cleanup on unload
    window.addEventListener('unload', () => {
        clearInterval(autoSaveTimer);
        if (isFormDirty) {
            triggerAutoSave(); // Final save attempt
        }
    });

    // Auto scroll to errors
    const errors = document.querySelectorAll('.error-message');
    if (errors.length > 0) {
        errors[0].scrollIntoView({ behavior: 'smooth', block: 'center' });
    }

    // Prevent Enter key submission in textareas
    document.querySelectorAll('textarea').forEach(textarea => {
        textarea.addEventListener('keydown', function(e) {
            if (e.key === 'Enter' && !e.shiftKey) {
                e.preventDefault();
            }
        });
    });
});
</script>
@endpush