<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Harris Pop</title>
    <link rel="stylesheet" href="{{ asset('assets/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/vendor/fontawesome/css/all.min.css') }}">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        /* ========== VARIABEL WARNA & TYPOGRAPHY ========== */
        :root {
            /* Primary Colors */
            --navy: #0f2a4d;
            --navy-medium: #1a2e45;
            --navy-light: #2a3e5a;
            /* Accent Colors */
            --accent-blue: #5d8fd9;
            --accent-blue-light: #8cb7f0;
            --accent-blue-lightest: #e8f1fd;
            /* Highlight - Orange hanya untuk action penting */
            --primary-orange: #f59e0b;
            --primary-orange-dark: #d97706;
            --primary-orange-light: #fef3c7;
            /* Neutral Colors */
            --white: #ffffff;
            --gray-50: #f8fafc;
            --gray-100: #f1f5f9;
            --gray-200: #e2e8f0;
            --gray-300: #cbd5e1;
            --gray-400: #94a3b8;
            --gray-500: #64748b;
            --gray-600: #475569;
            --gray-700: #334155;
            --gray-800: #1e293b;
            --gray-900: #0f172a;
            /* Semantic Colors */
            --success: #10b981;
            --success-light: #d1fae5;
            --warning: #f59e0b;
            --warning-light: #fef3c7;
            --danger: #ef4444;
            --danger-light: #fee2e2;
            --info: #3b82f6;
            --info-light: #dbeafe;
            /* Shadows & Effects */
            --shadow-xs: 0 1px 2px rgba(0, 0, 0, 0.05);
            --shadow-sm: 0 1px 3px rgba(0, 0, 0, 0.08);
            --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
            --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
            --shadow-xl: 0 20px 25px -5px rgba(0, 0, 0, 0.1);
            /* Transitions */
            --transition-fast: all 0.15s ease;
            --transition-normal: all 0.25s cubic-bezier(0.4, 0, 0.2, 1);
            --transition-slow: all 0.3s ease;
            /* Border Radius */
            --radius-sm: 6px;
            --radius-md: 10px;
            --radius-lg: 14px;
            --radius-xl: 20px;
            --radius-full: 9999px;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
            color: var(--gray-800);
            line-height: 1.5;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            min-height: 100vh;
        }

        a {
            text-decoration: none;
            color: inherit;
            transition: var(--transition-fast);
        }

        /* ========== DESKTOP LAYOUT ========== */
        .layout {
            display: grid;
            grid-template-columns: 260px 1fr;
            height: 100vh;
            position: relative;
        }

        /* ========== SIDEBAR IMPROVED ========== */
        .sidebar {
            background: linear-gradient(180deg, var(--navy) 0%, var(--navy-medium) 100%);
            color: var(--white);
            padding: 28px 20px 24px;
            box-shadow: var(--shadow-lg);
            display: flex;
            flex-direction: column;
            position: relative;
            z-index: 10;
            height: 100vh;
            overflow-y: hidden;
        }

       .sidebar::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 100%;
            height: 100%;
            background: url("data:image/svg+xml;base64,PHN2ZyB3aWR0aD0nMTAwJyBoZWlnaHQ9JzEwMCcgdmlld0JveD0nMCAwIDEwMCAxMDAnIHhtbG5zPSdodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2Zyc+PGNpcmNsZSBjeD0nOTAnIGN5PScxMCcgcj0nNScgZmlsbD0nd2hpdGUnIG9wYWNpdHk9JzAuMDUnLz48Y2lyY2xlIGN4PSc4MCcgY3k9JzkwJyByPSc4JyBmaWxsPSd3aGl0ZScgb3BhY2l0eT0nMC4wNScvPjxjaXJjbGUgY3g9JzIwJyBjeT0nNDAnIHI9JzYnIGZpbGw9J3doaXRlJyBvcGFjaXR5PScwLjA1Jy8+PC9zdmc+");
            pointer-events: none;
        }

        .sidebar-header {
            text-align: center;
            margin-bottom: 36px;
            padding: 0 8px;
        }

        .sidebar-header h1 {
            font-weight: 800;
            font-size: 1.85rem;
            letter-spacing: -0.5px;
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 10px 16px;
            background: rgba(255, 255, 255, 0.08);
            border-radius: var(--radius-lg);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .logo-container {
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 12px 20px;
            background: rgba(255, 255, 255, 0.15);
            /* Putih transparan */
            border-radius: var(--radius-lg);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            max-width: fit-content;
            margin: 0 auto;
            transition: transform 0.2s ease;
        }

        .logo-container img {
            height: 60px;
            width: auto;
            display: block;
            object-fit: contain;
            filter: brightness(1.1) contrast(1.05);
        }

        .nav-menu {
            list-style: none;
            flex: 1;
            padding: 0 4px;
        }

        .nav-item {
            margin-bottom: 8px;
            position: relative;
        }

        .nav-link {
            display: flex;
            align-items: center;
            padding: 16px 20px;
            border-radius: var(--radius-lg);
            transition: var(--transition-normal);
            color: rgba(255, 255, 255, 0.82);
            font-weight: 500;
            gap: 16px;
            position: relative;
            overflow: hidden;
            border: 1px solid transparent;
        }

        .nav-link i {
            font-size: 1.2rem;
            width: 24px;
            text-align: center;
            color: rgba(255, 255, 255, 0.6);
            transition: var(--transition-normal);
        }

        .nav-link:hover {
            color: var(--white);
            background: rgba(93, 143, 217, 0.2);
            border-color: rgba(93, 143, 217, 0.3);
            transform: translateX(4px);
        }

        .nav-link:hover i {
            color: var(--accent-blue-light);
            transform: scale(1.1);
        }

        .nav-link.active {
            background: linear-gradient(135deg, rgba(93, 143, 217, 0.25) 0%, rgba(140, 183, 240, 0.15) 100%);
            color: var(--white);
            border-color: rgba(93, 143, 217, 0.4);
            box-shadow: 0 4px 12px rgba(93, 143, 217, 0.15);
        }

        .nav-link.active::before {
            content: '';
            position: absolute;
            left: 0;
            top: 50%;
            transform: translateY(-50%);
            width: 4px;
            height: 32px;
            background: linear-gradient(to bottom, var(--accent-blue), var(--accent-blue-light));
            border-radius: 0 var(--radius-md) var(--radius-md) 0;
        }

        .nav-link.active i {
            color: var(--accent-blue-light);
            transform: scale(1.1);
        }

        /* ========== MAIN CONTENT IMPROVED ========== */
        .main-content {
            display: flex;
            flex-direction: column;
            height: 100vh;
        }

        .header {
            background: var(--white);
            padding: 0 32px;
            display: flex;
            justify-content: flex-end;
            align-items: center;
            flex-shrink: 0;
            border-bottom: 1px solid var(--gray-200);
            height: 80px;
            position: sticky;
            top: 0;
            z-index: 20;
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            background: rgba(255, 255, 255, 0.9);
        }

        .user-card {
            display: flex;
            align-items: center;
            gap: 16px;
            position: relative;
            cursor: pointer;
            padding: 8px 12px;
            border-radius: var(--radius-lg);
            transition: var(--transition-normal);
        }

        .user-card:hover {
            background: var(--gray-50);
        }

        .dropdown-toggle::after {
            display: none !important;
        }

        .avatar {
            width: 44px;
            height: 44px;
            border-radius: 50%;
            background: #f1f5f9;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #475569;
            font-weight: 700;
            font-size: 1.1rem;
            line-height: 1;
        }

        .user-info {
            text-align: left;
            flex: 1;
            min-width: 0;
        }

        .user-name {
            font-size: 1.05rem;
            font-weight: 600;
            margin-bottom: 2px;
            color: var(--gray-800);
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            max-width: 180px;
        }

        .user-role {
            font-size: 0.85rem;
            color: var(--gray-500);
            font-weight: 500;
            display: flex;
            align-items: center;
        }

        .user-role::before {
            width: 6px;
            height: 6px;
            border-radius: 50%;
            display: inline-block;
            background: var(--success);
        }

        .dropdown-toggle {
            background: none;
            border: none;
            color: var(--gray-500);
            cursor: pointer;
            font-size: 0.9rem;
            display: flex;
            align-items: center;
            transition: var(--transition-normal);
            padding: 8px;
            border-radius: var(--radius-md);
        }

        .dropdown-toggle:hover {
            color: var(--gray-800);
            background: var(--gray-100);
        }

        .dropdown-toggle i {
            transition: transform 0.3s ease;
        }

        .dropdown-toggle.rotated i {
            transform: rotate(180deg);
        }

        .dropdown-menu {
            position: absolute;
            top: calc(100% + 8px);
            right: 0;
            background: var(--white);
            border-radius: var(--radius-lg);
            box-shadow: var(--shadow-xl);
            padding: 8px 0;
            min-width: 220px;
            z-index: 1001;
            display: none;
            border: 1px solid var(--gray-200);
            animation: slideDown 0.2s cubic-bezier(0.4, 0, 0.2, 1);
            overflow: hidden;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px) scale(0.95);
            }

            to {
                opacity: 1;
                transform: translateY(0) scale(1);
            }
        }

        .dropdown-menu.show {
            display: block;
        }

        .dropdown-item {
            display: flex;
            align-items: center;
            padding: 14px 20px;
            color: var(--gray-700);
            font-size: 0.95rem;
            font-weight: 500;
            transition: var(--transition-fast);
            gap: 12px;
            border-left: 3px solid transparent;
        }

        .dropdown-item:hover {
            background: var(--gray-50);
            color: var(--accent-blue);
            padding-left: 22px;
            border-left-color: var(--accent-blue);
        }

        .dropdown-item i {
            width: 20px;
            text-align: center;
            font-size: 1.1rem;
            color: var(--gray-500);
            transition: var(--transition-fast);
        }

        .dropdown-item:hover i {
            color: var(--accent-blue);
            transform: translateX(2px);
        }

        .dropdown-item.highlight {
            color: var(--primary-orange);
            font-weight: 600;
        }

        .dropdown-item.highlight:hover {
            background: var(--primary-orange-light);
            color: var(--primary-orange-dark);
        }

        .dropdown-item.highlight:hover i {
            color: var(--primary-orange-dark);
        }

        .content-area {
            flex: 1;
            padding: 32px;
            overflow-y: auto;
            background: transparent;
            position: relative;
            max-height: calc(100vh - 80px - 60px);
        }

        .content-area::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 240px;
            background: linear-gradient(135deg, var(--accent-blue-lightest) 0%, transparent 100%);
            z-index: -1;
        }

        .footer {
            text-align: center;
            padding: 20px 32px;
            color: var(--gray-500);
            font-size: 0.85rem;
            flex-shrink: 0;
            background: var(--white);
            border-top: 1px solid var(--gray-200);
        }

        /* ========== MOBILE LAYOUT IMPROVED ========== */
        .mobile-container {
            display: none;
            flex-direction: column;
            min-height: 100vh;
            background: var(--gray-50);
        }

        .mobile-header {
            width: 100%;
            background: linear-gradient(135deg, var(--navy) 0%, var(--navy-medium) 100%);
            padding: 28px 20px 20px;
            color: var(--white);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 50;
            box-shadow: var(--shadow-md);
            border-radius: 0 0 24px 24px;
            overflow: hidden;
        }

        .mobile-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url("data:image/svg+xml;base64,PHN2ZyB3aWR0aD0nMTAwJyBoZWlnaHQ9JzEwMCcgdmlld0JveD0nMCAwIDEwMCAxMDAnIHhtbG5zPSdodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2Zyc+PGNpcmNsZSBjeD0nMTAnIGN5PScxMCcgcj0nMycgZmlsbD0nd2hpdGUnIG9wYWNpdHk9JzAuMScvPjxjaXJjbGUgY3g9JzkwJyBjeT0nMjAnIHI9JzQnIGZpbGw9J3doaXRlJyBvcGFjaXR5PScwLjEnLz48Y2lyY2xlIGN4PSc1MCcgY3k9JzgwJyByPSc2JyBmaWxsPSd3aGl0ZScgb3BhY2l0eT0nMC4xJy8+PC9zdmc+");
            pointer-events: none;
        }

        .mobile-header-content {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            position: relative;
            z-index: 1;
        }

        .mobile-greeting h1 {
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 6px;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
        }

        .mobile-greeting p {
            font-size: 0.9rem;
            opacity: 0.9;
            font-weight: 500;
            color: rgba(255, 255, 255, 0.9);
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .mobile-greeting p::before {
            content: '';
            width: 6px;
            height: 6px;
            background: var(--success);
            border-radius: 50%;
            display: inline-block;
        }

        .mobile-avatar {
            width: 60px;
            height: 60px;
            border-radius: var(--radius-full);
            background: white;
            display: flex;
            align-items: center;
            margin-right: 5px;
            justify-content: center;
            color: black;
            font-weight: bold;
            font-size: 1.3rem;
            box-shadow: var(--shadow-lg);
            border: 3px solid rgba(255, 255, 255, 0.2);
        }

        .mobile-content {
            flex: 1;
            overflow-y: auto;
            padding: 140px 20px 90px;
            -webkit-overflow-scrolling: touch;
        }

        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: var(--white);
            border-top: 1px solid var(--gray-200);
            display: flex;
            justify-content: space-around;
            padding: 12px 0;
            box-shadow: 0 -4px 20px rgba(0, 0, 0, 0.08);
            z-index: 40;
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            background: rgba(255, 255, 255, 0.95);
        }

        .bottom-nav a {
            display: flex;
            flex-direction: column;
            align-items: center;
            font-size: 0.82rem;
            color: var(--gray-500);
            padding: 8px 16px;
            transition: var(--transition-normal);
            border-radius: var(--radius-lg);
            position: relative;
        }

        .bottom-nav a:hover {
            color: var(--accent-blue);
            background: var(--gray-50);
        }

        .bottom-nav a.active {
            color: var(--accent-blue);
            font-weight: 600;
        }

        .bottom-nav i {
            font-size: 1.4rem;
            margin-bottom: 6px;
            color: var(--gray-500);
            transition: var(--transition-normal);
        }

        .bottom-nav a:hover i,
        .bottom-nav a.active i {
            color: var(--accent-blue);
            transform: translateY(-2px);
        }

        .bottom-nav a.active::after {
            content: '';
            position: absolute;
            bottom: 4px;
            left: 50%;
            transform: translateX(-50%);
            width: 24px;
            height: 3px;
            background: var(--accent-blue);
            border-radius: 3px;
        }

        /* ========== RESPONSIVE ADJUSTMENTS ========== */
        @media (max-width: 1023px) {
            .layout {
                display: none;
            }

            .mobile-container {
                display: flex !important;
            }
        }

        @media (max-width: 768px) {
            .header {
                padding: 0 20px;
                height: 70px;
            }

            .avatar {
                width: 44px;
                height: 44px;
                font-size: 1.1rem;
            }

            .user-name {
                max-width: 140px;
            }

            .content-area {
                padding: 24px;
            }
        }

        @media (max-width: 480px) {
            .sidebar-header h1 {
                font-size: 1.5rem;
            }

            .nav-link {
                padding: 14px 16px;
            }

            .mobile-header {
                padding: 24px 16px 16px;
                border-radius: 0 0 20px 20px;
            }

            .mobile-content {
                padding: 130px 16px 80px;
            }

            .bottom-nav a {
                padding: 8px 12px;
            }

            .bottom-nav i {
                font-size: 1.3rem;
            }
        }

        /* ========== SCROLLBAR STYLING ========== */
        ::-webkit-scrollbar {
            width: 8px;
            height: 8px;
        }

        ::-webkit-scrollbar-track {
            background: var(--gray-100);
            border-radius: 4px;
        }

        ::-webkit-scrollbar-thumb {
            background: var(--gray-300);
            border-radius: 4px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: var(--gray-400);
        }

        * {
            scrollbar-width: thin;
            scrollbar-color: var(--gray-300) var(--gray-100);
        }

        /* ========== FIX: HIDE MOBILE CONTAINER ON DESKTOP ========== */
        @media (min-width: 1024px) {
            .mobile-container {
                display: none !important;
            }
            .bottom-nav {
                display: none !important;
            }
        }
    </style>
    @stack('styles')
</head>

<body>

    <!-- DESKTOP LAYOUT -->
    <div class="layout">
        <!-- SIDEBAR -->
        <aside class="sidebar">
            <div class="sidebar-header">
                <div class="logo-container">
                    <img src="{{ asset('assets/logoo.png') }}" alt="Harris Pop Logo">
                </div>
            </div>
            <ul class="nav-menu">
                <li class="nav-item">
                    <a href="{{ route('user.dashboard') }}"
                        class="nav-link {{ request()->routeIs('user.dashboard') ? 'active' : '' }}">
                        <i class="fas fa-home"></i>
                        <span>Home</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('user.jadwal') }}" class="nav-link {{ request()->routeIs('user.jadwal*') ? 'active' : '' }}">
                        <i class="fas fa-calendar-alt"></i>
                        <span>Jadwal</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('user.mod') }}"
                        class="nav-link {{ request()->routeIs('user.mod','user.checklist.fill') ? 'active' : '' }}">
                        <i class="fas fa-list"></i>
                        <span>Mod</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('user.profile') }}"
                        class="nav-link {{ request()->routeIs('user.profile*') ? 'active' : '' }}">
                        <i class="fas fa-user"></i>
                        <span>Profile</span>
                    </a>
                </li>
            </ul>
        </aside>

        <!-- MAIN CONTENT -->
        <main class="main-content">
            <header class="header">
                <div class="user-card">
                    <div class="avatar">
                        {{ strtoupper(substr(auth()->user()->name ?? 'U', 0, 1)) }}
                    </div>
                    <div class="user-info">
                        <div class="user-name">{{ auth()->user()->name ?? 'User' }}</div>
                        <div class="user-role">{{ optional(auth()->user())->role?->name ?? 'Role' }}</div>
                    </div>
                    <button class="dropdown-toggle" id="userDropdown">
                        <i class="fas fa-chevron-down"></i>
                    </button>
                    <div class="dropdown-menu" id="dropdownMenu">
                        <a href="{{ route('user.profile') }}" class="dropdown-item">
                            <i class="fas fa-user-circle"></i>
                            <span>Profile Saya</span>
                        </a>
                        <div class="dropdown-divider"></div>
                        <a href="{{ route('logout') }}" class="dropdown-item highlight"
                            onclick="confirmLogout(event)">
                            <i class="fas fa-sign-out-alt"></i>
                            <span>Logout</span>
                        </a>
                        <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                            @csrf
                        </form>
                    </div>
                </div>
            </header>

            <div class="content-area">
                @yield('content')
            </div>

            <footer class="footer">
                <div>© {{ date('Y') }} Harris Pop. All rights reserved.</div>
            </footer>
        </main>
    </div>

    <!-- MOBILE LAYOUT -->
    <div class="mobile-container">
        @if (!isset($hideMobileHeader) || !$hideMobileHeader)
            <div class="mobile-header">
                <div class="mobile-header-content">
                    <div class="mobile-greeting">
                        <h1>Halo, {{ auth()->user()->name ?? 'User' }}</h1>
                        <p>{{ optional(auth()->user())->role?->name ?? 'Role' }}</p>
                    </div>
                    <div class="mobile-avatar">
                        {{ strtoupper(substr(auth()->user()->name ?? 'U', 0, 1)) }}
                    </div>
                </div>
            </div>
        @endif

        <div class="mobile-content" style="@if (isset($hideMobileHeader) && $hideMobileHeader) padding-top: 20px !important; @endif">
            @yield('mobile-content')
        </div>
        <nav class="bottom-nav">
            <a href="{{ route('user.dashboard') }}"
                class="{{ request()->routeIs('user.dashboard') ? 'active' : '' }}">
                <i class="fas fa-home"></i>
                <span>Home</span>
            </a>
            <a href="{{ route('user.jadwal') }}" class="{{ request()->routeIs('user.jadwal*') ? 'active' : '' }}">
                <i class="fas fa-calendar-alt"></i>
                <span>Jadwal</span>
            </a>
            <a href="{{ route('user.mod') }}" class="{{ request()->routeIs('user.mod','user.checklist.fill') ? 'active' : '' }}">
                <i class="fas fa-list"></i>
                <span>Mod</span>
            </a>
            <a href="{{ route('user.profile') }}" class="{{ request()->routeIs('user.profile') ? 'active' : '' }}">
                <i class="fas fa-user"></i>
                <span>Profile</span>
            </a>
        </nav>
    </div>

    <script src="{{ asset('assets/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('assets/dist/sweetalert2.all.js') }}"></script>
    @stack('scripts')
    @yield('scripts')

    @if (session('login_success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: 'Login Berhasil!',
                text: "{{ session('login_success') }}",
                timer: 2000,
                showConfirmButton: false,
                background: 'var(--white)',
                color: 'var(--gray-800)',
                iconColor: 'var(--success)'
            });
        </script>
    @endif

    @if (session('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: 'Berhasil!',
                text: "{{ session('success') }}",
                timer: 2000,
                showConfirmButton: false,
                background: 'var(--white)',
                color: 'var(--gray-800)',
                iconColor: 'var(--success)'
            });
        </script>
    @endif

    <script>
        // Enhanced Logout Confirmation
        function confirmLogout(event) {
            event.preventDefault();

            Swal.fire({
                title: 'Logout?',
                text: "Apakah Anda yakin ingin keluar dari sistem?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Ya, Logout',
                cancelButtonText: 'Batal',
                reverseButtons: true,
                backdrop: 'rgba(0, 0, 0, 0.4)',
                allowOutsideClick: false,
                allowEscapeKey: true,
                customClass: {
                    popup: 'custom-swal-popup'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    // Show loading
                    Swal.fire({
                        title: 'Sedang Logout',
                        text: 'Harap tunggu...',
                        allowOutsideClick: false,
                        allowEscapeKey: false,
                        didOpen: () => {
                            Swal.showLoading();
                        }
                    });

                    // Submit logout form
                    setTimeout(() => {
                        const form = document.createElement('form');
                        form.method = 'POST';
                        form.action = '{{ route('logout') }}';

                        const csrfToken = document.createElement('input');
                        csrfToken.type = 'hidden';
                        csrfToken.name = '_token';
                        csrfToken.value = '{{ csrf_token() }}';

                        form.appendChild(csrfToken);
                        document.body.appendChild(form);
                        form.submit();
                    }, 800);
                }
            });
        }
        document.addEventListener('DOMContentLoaded', function() {
            const toggle = document.getElementById('userDropdown');
            const menu = document.getElementById('dropdownMenu');
            if (toggle && menu) {
                toggle.addEventListener('click', function(e) {
                    e.stopPropagation();
                    menu.classList.toggle('show');
                    toggle.classList.toggle('rotated');
                });
                document.addEventListener('click', function(e) {
                    if (!toggle.contains(e.target) && !menu.contains(e.target)) {
                        menu.classList.remove('show');
                        toggle.classList.remove('rotated');
                    }
                });
                document.addEventListener('keydown', function(e) {
                    if (e.key === 'Escape') {
                        menu.classList.remove('show');
                        toggle.classList.remove('rotated');
                    }
                });
            }
        });
    </script>

</body>

</html>