@extends('layouts.AdminLayout')

@section('content')
    <!-- Header Area -->
    <div class="d-flex flex-column flex-lg-row justify-content-between align-items-start align-items-lg-center mb-4 gap-3">
        <div>
            <h1 class="dashboard-title">Manajemen Pengguna</h1>
            @if (request('search') || request('sort'))
                <small class="text-muted d-block mt-1">
                    <i class="fas fa-filter me-1"></i>
                    {{ $users->total() }} pengguna ditemukan
                    @if (request('search'))
                        • kata kunci: <code>{{ request('search') }}</code>
                    @endif
                    @if (request('sort') === 'name_asc')
                        • <i class="fas fa-sort-alpha-down"></i> A→Z
                    @endif
                    @if (request('sort') === 'name_desc')
                        • <i class="fas fa-sort-alpha-up"></i> Z→A
                    @endif
                </small>
            @endif
        </div>
        @if (request('search') || request('sort'))
            <a href="{{ route('admin.manajemen.usermanajemen') }}" class="btn btn-sm btn-outline-gray-500">
                <i class="fas fa-undo me-1"></i> Reset Filter
            </a>
        @endif
    </div>

    <!-- Unified Search & Sort Bar -->
    <div class="card p-3 mb-4 rounded-3 shadow-sm border-0">
        <form method="GET" class="row g-2 align-items-center">
            <div class="col-12 col-md-6">
                <div class="input-group">
                    <span class="input-group-text bg-gray-100 border-gray-300">
                        <i class="fas fa-search text-gray-500"></i>
                    </span>
                    <input type="text" name="search" class="form-control rounded-start-0 border-gray-300"
                        placeholder="Cari nama/email..." value="{{ request('search') }}">
                </div>
            </div>
            <div class="col-12 col-md-6 text-md-end">
                <div class="btn-group" role="group" aria-label="Sort Options">
                    <a href="{{ request()->fullUrlWithQuery(['sort' => 'name_asc']) }}"
                        class="btn btn-sm {{ request('sort') === 'name_asc' ? 'btn-primary text-white' : 'btn-outline-gray-500' }}">
                        <i class="fas fa-sort-alpha-down me-1"></i> A→Z
                    </a>
                    <a href="{{ request()->fullUrlWithQuery(['sort' => 'name_desc']) }}"
                        class="btn btn-sm {{ request('sort') === 'name_desc' ? 'btn-primary text-white' : 'btn-outline-gray-500' }}">
                        <i class="fas fa-sort-alpha-up me-1"></i> Z→A
                    </a>
                </div>
            </div>
        </form>
    </div>

    <!-- User List -->
    <div class="requests-list">
        @forelse($users as $user)
            <div class="request-card">
                <div class="request-info d-flex align-items-center flex-grow-1">
                    <div class="avatar me-3">
                        {{ strtoupper(substr($user->name ?? 'U', 0, 1)) }}
                    </div>
                    <div class="flex-grow-1">
                        <div class="request-name fw-semibold">{{ $user->name }}</div>
                        <div class="request-email text-gray-600 d-flex align-items-center gap-1">
                            <i class="fas fa-envelope fa-xs"></i>
                            <span class="text-truncate">{{ $user->email }}</span>
                        </div>
                    </div>
                </div>
                <div class="request-actions ms-2">
                    <button type="button" class="btn btn-icon btn-outline-gray-300 text-danger rounded-circle"
                        data-bs-toggle="modal" data-bs-target="#hapusUser{{ $user->id }}"
                        aria-label="Hapus {{ $user->name }}">
                        <i class="fas fa-trash-alt fa-sm"></i>
                    </button>
                </div>
            </div>
        @empty
            <div class="empty-state py-5 text-center">
                <div class="avatar mx-auto mb-3" style="width: 64px; height: 64px; font-size: 1.8rem;">
                    U
                </div>
                <h3 class="h5 fw-bold mb-2">Tidak Ada Pengguna</h3>
                <p class="text-gray-600 mb-3">
                    @if (request('search'))
                        Tidak ditemukan pengguna dengan kata kunci "<strong>{{ request('search') }}</strong>".
                    @else
                        Belum ada pengguna terdaftar untuk peran ini.
                    @endif
                </p>
                @if (request('search'))
                    <a href="{{ route('admin.manajemen.usermanajemen') }}" class="btn btn-sm btn-outline-gray-500">
                        <i class="fas fa-list me-1"></i> Lihat Semua
                    </a>
                @endif
            </div>
        @endforelse
    </div>

    <!-- Pagination -->
    @if ($users->hasPages())
        <div class="mt-4 d-flex justify-content-center">
            {{ $users->appends(request()->query())->links() }}
        </div>
    @endif
@endsection


@section('mobile-content')
    <!-- MOBILE-ONLY: full-screen overlay -->
    <div class="mobile-overlay">
        <!-- Topbar -->
        <div class="mobile-topbar">
            <a href="{{ route('admin.dashboard') }}" class="back-btn">
                <i class="fas fa-arrow-left"></i>
            </a>
            <h2 class="topbar-title">Manajemen Pengguna</h2>
            <a class="options-btn" id="optionsToggle">
                <i class="fas fa-ellipsis-v"></i>
            </a>

            <!-- Dropdown -->
            <div class="options-dropdown" id="optionsDropdown">
                <a href="{{ request()->fullUrlWithQuery(['sort' => 'name_asc']) }}"
                    class="dropdown-item {{ request('sort') === 'name_asc' ? 'active' : '' }}">
                    <i class="fas fa-sort-alpha-down me-2"></i> Nama (A→Z)
                </a>
                <a href="{{ request()->fullUrlWithQuery(['sort' => 'name_desc']) }}"
                    class="dropdown-item {{ request('sort') === 'name_desc' ? 'active' : '' }}">
                    <i class="fas fa-sort-alpha-up me-2"></i> Nama (Z→A)
                </a>
                <a href="{{ route('admin.manajemen.usermanajemen') }}" class="dropdown-item text-gray-600">
                    <i class="fas fa-undo me-2"></i> Reset Filter
                </a>
            </div>
        </div>

        <!-- Scrollable Content -->
        <div class="mobile-main-content">
            <!-- Search -->
            <form method="GET" class="mb-2">
                <div class="input-group">
                    <input type="text" name="search" class="form-control rounded-start" placeholder="Cari pengguna..."
                        value="{{ request('search') }}">
                    <button class="btn btn-primary rounded-end" type="submit">
                        <i class="fas fa-search text-white"></i>
                    </button>
                </div>
            </form>

            <!-- Info Ringkas -->
            @if (request('search') || request('sort'))
                <small class="text-gray-500 d-block text-center mb-2">
                    {{ $users->total() }} pengguna
                    @if (request('sort'))
                        • {{ request('sort') === 'name_asc' ? 'A→Z' : 'Z→A' }}
                    @endif
                </small>
            @endif

            <!-- User List -->
            <div class="requests-list">
                @forelse($users as $user)
                    <div class="request-card">
                        <div class="request-info d-flex align-items-center">
                            <div class="avatar me-3">
                                {{ strtoupper(substr($user->name ?? 'U', 0, 1)) }}
                            </div>
                            <div class="flex-grow-1">
                                <div class="request-name fw-medium">{{ $user->name }}</div>
                                <div class="request-email text-gray-600 text-truncate">
                                    {{ $user->email }}
                                </div>
                            </div>
                            <button type="button" class="btn btn-icon btn-outline-gray-200 text-danger rounded-circle ms-2"
                                data-bs-toggle="modal" data-bs-target="#hapusUser{{ $user->id }}" aria-label="Hapus">
                                <i class="fas fa-trash-alt fa-xs"></i>
                            </button>
                        </div>
                    </div>
                @empty
                    <div class="empty-state py-4 text-center">
                        <i class="fas fa-users text-gray-400 mb-2" style="font-size: 2rem;"></i>
                        <p class="text-gray-600 mb-0">
                            @if (request('search'))
                                Tidak ada hasil untuk "<strong>{{ request('search') }}</strong>".
                            @else
                                Belum ada pengguna.
                            @endif
                        </p>
                    </div>
                @endforelse
            </div>

            <!-- Pagination -->
            {{-- @if ($users->hasPages())
                <div class="mt-3">
                    {{ $users->appends(request()->query())->links('vendor.pagination.simple-bootstrap-5') }}
                </div>
            @endif --}}
        </div>
    </div>
@endsection


@push('modals')
    @include('admin.manajemen.modal.user_delete')
@endpush


@push('styles')
    <style>
        /* ===== Shared Color Variables ===== */
        :root {
            --bg-primary: #f8fafc;
            --bg-card: #ffffff;
            --text-primary: #1e293b;
            --text-secondary: #64748b;
            --border-color: #e2e8f0;
            --btn-primary: #4f46e5;
            --btn-primary-hover: #4338ca;
            --btn-danger: #ef4444;
            --btn-outline: #cbd5e1;
            --shadow-sm: 0 2px 6px rgba(0, 0, 0, 0.04);
            --shadow-md: 0 4px 12px rgba(0, 0, 0, 0.06);
            --radius-sm: 8px;
            --radius-md: 12px;
            --radius-lg: 16px;
        }

        /* ===== Utility Classes ===== */
        .text-gray-500 {
            color: var(--text-secondary) !important;
        }

        .text-gray-600 {
            color: #475569 !important;
        }

        .border-gray-300 {
            border-color: var(--border-color) !important;
        }

        .bg-gray-100 {
            background-color: #f1f5f9 !important;
        }

        .btn-outline-gray-500 {
            color: var(--text-secondary);
            border-color: var(--btn-outline);
            background: transparent;
        }

        .btn-outline-gray-500:hover {
            background: #f1f5f9;
            border-color: #94a3b8;
        }

        .btn-primary {
            background: var(--btn-primary);
            border-color: var(--btn-primary);
        }

        .btn-primary:hover {
            background: var(--btn-primary-hover);
            border-color: var(--btn-primary-hover);
        }

        code {
            background: #f1f5f9;
            padding: 2px 6px;
            border-radius: 4px;
            font-size: 0.85em;
        }

        .text-truncate {
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        /* ===== Avatar Shared ===== */
        .avatar {
            width: 44px;
            height: 44px;
            border-radius: 50%;
            background: #f1f5f9;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #475569;
            font-weight: 700;
            font-size: 1.1rem;
            line-height: 1;
        }

        /* ===== Desktop (≥992px) ===== */
        @media (min-width: 992px) {
            .dashboard-title {
                font-size: 1.75rem;
                font-weight: 700;
                color: var(--text-primary);
                margin-bottom: 0;
            }

            .requests-list {
                display: flex;
                flex-direction: column;
                gap: 12px;
            }

            .request-card {
                background: var(--bg-card);
                border-radius: var(--radius-md);
                padding: 16px;
                box-shadow: var(--shadow-sm);
                border: 1px solid var(--border-color);
                display: flex;
                align-items: center;
                transition: all 0.25s cubic-bezier(0.25, 0.46, 0.45, 0.94);
            }

            .request-card:hover {
                transform: translateY(-2px);
                box-shadow: var(--shadow-md);
                border-color: #cbd5e1;
            }

            .request-name {
                font-size: 1.05rem;
                color: var(--text-primary);
            }

            .request-email {
                font-size: 0.875rem;
                color: var(--text-secondary);
            }

            .btn-icon {
                width: 36px;
                height: 36px;
                padding: 0;
                display: flex;
                align-items: center;
                justify-content: center;
                border-width: 1px;
            }

            .empty-state {
                max-width: 500px;
                margin: 2rem auto;
                background: var(--bg-card);
                border-radius: var(--radius-lg);
                padding: 2.5rem 2rem;
                box-shadow: var(--shadow-sm);
            }

            .empty-state i,
            .empty-state .avatar {
                color: #94a3b8;
            }
        }

        /* ===== Mobile (<992px) ===== */
        @media (max-width: 991px) {
            .layout {
                display: none !important;
            }

            .modal-backdrop {
                z-index: 10001 !important;
            }

            .modal {
                z-index: 10002 !important;
            }

            .mobile-overlay {
                position: fixed;
                inset: 0;
                background: var(--bg-primary);
                z-index: 10000;
                display: flex;
                flex-direction: column;
            }

            .mobile-topbar {
                position: sticky;
                top: 0;
                background: #1e293b;
                /* Navy */
                padding: 12px 16px;
                z-index: 100;
                box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
                display: flex;
                justify-content: space-between;
                align-items: center;
            }

            .back-btn,
            .options-btn {
                width: 32px;
                height: 32px;
                background: transparent;
                display: flex;
                align-items: center;
                justify-content: center;
                color: white;
                text-decoration: none;
                font-size: 1.1rem;
            }

            .back-btn:hover,
            .options-btn:hover {
                background: rgba(255, 255, 255, 0.1);
                border-radius: 6px;
            }

            .topbar-title {
                color: white;
                font-size: 1.1rem;
                font-weight: 600;
                flex: 1;
                text-align: center;
                margin: 0 8px;
            }

            .options-dropdown {
                position: absolute;
                top: 50px;
                right: 16px;
                background: white;
                border-radius: var(--radius-md);
                box-shadow: 0 8px 24px rgba(0, 0, 0, 0.15);
                width: 200px;
                overflow: hidden;
                display: none;
                z-index: 101;
            }

            .options-dropdown.show {
                display: block;
            }

            .dropdown-item {
                padding: 10px 16px;
                display: flex;
                align-items: center;
                color: var(--text-primary);
                text-decoration: none;
                font-size: 0.9rem;
            }

            .dropdown-item:hover,
            .dropdown-item.active {
                background: #f8fafc;
            }

            .mobile-main-content {
                flex: 1;
                padding: 20px 16px 20px;
                /* Top padding minimized */
                overflow-y: auto;
            }

            .input-group .form-control {
                font-size: 0.9rem;
                padding: 8px 12px;
            }

            .input-group .btn {
                padding: 8px 12px;
                font-size: 0.9rem;
            }

            .request-card {
                background: var(--bg-card);
                border: 1px solid var(--border-color);
                border-radius: var(--radius-sm);
                padding: 12px;
                margin-bottom: 10px;
            }

            .avatar {
                width: 36px;
                height: 36px;
                font-size: 0.95rem;
            }

            .request-name {
                font-size: 0.95rem;
                font-weight: 600;
            }

            .request-email {
                font-size: 0.8rem;
                color: var(--text-secondary);
            }

            .btn-icon {
                width: 32px;
                height: 32px;
                padding: 0;
                font-size: 0.8rem;
            }

            .empty-state {
                padding: 1.5rem 1rem;
            }
        }
    </style>
@endpush


@push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const optionsToggle = document.getElementById('optionsToggle');
            const optionsDropdown = document.getElementById('optionsDropdown');

            if (optionsToggle && optionsDropdown) {
                optionsToggle.addEventListener('click', function(e) {
                    e.stopPropagation();
                    optionsDropdown.classList.toggle('show');
                });

                document.addEventListener('click', function(e) {
                    if (!optionsDropdown.contains(e.target) && e.target !== optionsToggle) {
                        optionsDropdown.classList.remove('show');
                    }
                });
            }

            // Smooth scroll to top on pagination (mobile only)
            const isMobile = window.innerWidth < 992;
            if (isMobile) {
                document.querySelectorAll('.pagination a').forEach(link => {
                    link.addEventListener('click', function(e) {
                        e.preventDefault();
                        const content = document.querySelector('.mobile-main-content');
                        if (content) {
                            content.scrollTo({
                                top: 0,
                                behavior: 'smooth'
                            });
                        }
                        setTimeout(() => window.location.href = this.href, 300);
                    });
                });
            }
        });
    </script>
@endpush
