<!-- ================= MODAL EDIT PERTANYAAN ================= -->
<div class="modal fade" id="editQuestionModal{{ $question->id }}" tabindex="-1"
    aria-labelledby="editQuestionModalLabel{{ $question->id }}" aria-hidden="true"
    data-question-id="{{ $question->id }}"
    data-question-type="{{ $question->type }}"
    data-question-text="{{ $question->question_text }}"
    data-is-required="{{ $question->is_required }}"
    data-has-comment="{{ $question->has_comment }}"
    data-comment-required="{{ $question->comment_required }}"
    data-image-required-if-no="{{ $question->image_required_if_no }}"
    data-sub-questions="{{ $question->subQuestions->toJson() }}">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content border-0 rounded-3 shadow">

            <!-- Header -->
            <div class="modal-header py-3 px-4 bg-primary bg-opacity-10">
                <h6 class="modal-title fw-semibold text-dark" id="editQuestionModalLabel{{ $question->id }}">
                    <i class="fas fa-edit me-2 text-primary"></i>
                    Edit Pertanyaan
                </h6>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <!-- Body -->
            <div class="modal-body pt-0 px-4 pb-4">
                <form action="{{ route('admin.manajemen.question.update', $question->id) }}" method="POST">
                    @csrf
                    
                    @method('PUT')

                    <!-- Info Question (tanpa ID) -->
                    <div class="alert alert-light border rounded mb-4 p-3 bg-primary-subtle border-primary-subtle">
                        <small class="text-muted d-block mb-1">Mengedit pertanyaan:</small>
                        <span class="badge bg-primary px-3 py-2">
                            <i class="fas fa-tag me-1"></i>
                            {{ ucfirst(str_replace('_', ' ', $question->type)) }}
                        </span>
                        <small class="text-muted d-block mt-2">Tipe ini tidak dapat diubah setelah dibuat.</small>
                    </div>

                    <!-- Judul Utama Pertanyaan -->
                    <div class="mb-3" id="editQuestionTextContainer_{{ $question->id }}">
                        <label class="form-label small fw-medium text-secondary">Teks Pertanyaan *</label>
                        <textarea class="form-control border-primary-subtle" name="question_text"
                            id="editQuestionText_{{ $question->id }}" rows="3"
                            placeholder="Masukkan pertanyaan...">{{ $question->question_text }}</textarea>
                    </div>

                    <!-- Dynamic Options Area -->
                    <div id="editDynamicOptions_{{ $question->id }}" class="mt-3">
                        <!-- Konten akan dirender oleh JavaScript -->
                    </div>

                    <hr class="my-4">

                    <div class="d-flex justify-content-between">

                        <!-- Tombol Simpan & Batal -->
                        <div class="d-flex gap-2">
                            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                                <i class="fas fa-times me-1"></i> Batal
                            </button>
                            <button type="submit" class="btn btn-primary py-2">
                                <i class="fas fa-save me-1"></i> Simpan Perubahan
                            </button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>
</div>

<!-- ================= JS UNTUK EDIT PERTANYAAN ================= -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const editModals = document.querySelectorAll('[id^="editQuestionModal"]');

    editModals.forEach(modal => {
        modal.addEventListener('shown.bs.modal', function(event) {
            const questionId = this.getAttribute('data-question-id');
            renderEditDynamicOptions(questionId);
        });
    });
});

function renderEditDynamicOptions(questionId) {
    const modal = document.getElementById('editQuestionModal' + questionId);
    if (!modal) return;

    const dynamic = document.getElementById('editDynamicOptions_' + questionId);
    const questionTextContainer = document.getElementById('editQuestionTextContainer_' + questionId);
    const questionText = document.getElementById('editQuestionText_' + questionId);

    if (!dynamic || !questionTextContainer || !questionText) return;

    const type = modal.getAttribute('data-question-type');

    const questionData = {
        id: modal.getAttribute('data-question-id'),
        type: type,
        question_text: modal.getAttribute('data-question-text'),
        is_required: parseInt(modal.getAttribute('data-is-required')),
        has_comment: parseInt(modal.getAttribute('data-has-comment')),
        comment_required: parseInt(modal.getAttribute('data-comment-required')),
        image_required_if_no: parseInt(modal.getAttribute('data-image-required-if-no'))
    };

    let subQuestions = [];
    try {
        const subQuestionsJson = modal.getAttribute('data-sub-questions');
        if (subQuestionsJson) {
            subQuestions = JSON.parse(subQuestionsJson);
        }
    } catch (e) {
        console.error('Error parsing sub questions:', e);
    }

    let html = '';

    if (type === 'yesNo') {
        questionTextContainer.style.display = 'block';
        questionText.placeholder = 'Masukkan pertanyaan Yes/No...';

        html = `
        <div class="border border-primary-subtle p-3 rounded bg-light">
            <p class="small fw-medium text-primary mb-3">
                <i class="fas fa-toggle-on me-1"></i> Pengaturan untuk tipe Yes/No:
            </p>

            <div class="form-check form-switch mb-3">
                <input class="form-check-input" type="checkbox" name="is_required" value="1"
                    ${questionData.is_required ? 'checked' : ''}>
                <label class="form-check-label fw-medium text-dark">Wajib diisi</label>
                <small class="text-muted d-block">Pertanyaan harus dijawab</small>
            </div>

            <div class="form-check form-switch mb-3">
                <input class="form-check-input edit-has-comment" data-question="${questionId}"
                    type="checkbox" name="has_comment" value="1"
                    ${questionData.has_comment ? 'checked' : ''}>
                <label class="form-check-label fw-medium text-dark">Memiliki Field Komentar</label>
                <small class="text-muted d-block">Pengguna dapat menambahkan komentar</small>
            </div>

            <div class="form-check form-switch mb-3">
                <input class="form-check-input edit-comment-child" data-question="${questionId}"
                    type="checkbox" name="comment_required" value="1"
                    ${questionData.comment_required ? 'checked' : ''}
                    ${!questionData.has_comment ? 'disabled' : ''}>
                <label class="form-check-label fw-medium text-dark">Komentar Wajib Diisi</label>
                <small class="text-muted d-block">Komentar harus diisi jika tersedia</small>
            </div>

            <div class="form-check form-switch">
                <input class="form-check-input" type="checkbox" name="image_required_if_no" value="1"
                    ${questionData.image_required_if_no ? 'checked' : ''}>
                <label class="form-check-label fw-medium text-dark">Wajib Upload Gambar jika Jawaban "No"</label>
                <small class="text-muted d-block">Foto diperlukan jika jawaban No</small>
            </div>
        </div>
        `;
    } else if (type === 'header') {
        questionTextContainer.style.display = 'block';
        questionText.placeholder = 'Masukkan teks header...';
        questionText.rows = 2;

        html = `
        <div class="border border-info-subtle p-3 rounded bg-light">
            <p class="small fw-medium text-info mb-3">
                <i class="fas fa-heading me-1"></i> Tipe Header akan ditampilkan sebagai judul atau pembatas section.
            </p>
            <div class="form-check form-switch mb-2">
                <input class="form-check-input" type="checkbox" name="is_required" value="0" disabled>
                <label class="form-check-label fw-medium text-secondary">Non-interaktif</label>
                <small class="text-muted d-block">Header tidak memerlukan jawaban</small>
            </div>
        </div>
        `;
    } else if (type === 'readOnlyText') {
        questionTextContainer.style.display = 'block';
        questionText.placeholder = 'Masukkan teks informasi...';

        html = `
        <div class="border border-info-subtle p-3 rounded bg-light">
            <p class="small fw-medium text-info mb-3">
                <i class="fas fa-file-alt me-1"></i> Tipe Read Only Text menampilkan informasi statis tanpa input.
            </p>
            <div class="form-check form-switch mb-2">
                <input class="form-check-input" type="checkbox" name="is_required" value="0" disabled>
                <label class="form-check-label fw-medium text-secondary">Hanya baca</label>
                <small class="text-muted d-block">Teks hanya untuk dibaca, tidak memerlukan jawaban</small>
            </div>
        </div>
        `;
    } else if (type === 'subQuestionList') {
        questionTextContainer.style.display = 'block';
        questionText.placeholder = 'Masukkan judul utama pertanyaan...';

        let subQuestionsHtml = '';
        if (subQuestions && subQuestions.length > 0) {
            subQuestions.forEach((sub, index) => {
                const escapedText = sub.text ? sub.text.replace(/"/g, '&quot;') : '';
                subQuestionsHtml += `
                <div class="sub-question-item mb-4 p-3 border border-primary-subtle rounded bg-white">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h6 class="mb-0 text-primary">Sub Pertanyaan ${index + 1}</h6>
                        <button type="button" class="btn btn-outline-danger btn-sm"
                            onclick="this.closest('.sub-question-item').remove(); updateEditSubQuestionNumbers(${questionId})">
                            <i class="fas fa-times"></i> Hapus
                        </button>
                    </div>

                    <input type="hidden" name="sub_questions[${index}][id]" value="${sub.id || ''}">

                    <div class="mb-3">
                        <label class="form-label small fw-medium text-secondary">Label *</label>
                        <input type="text"
                               class="form-control border-primary-subtle"
                               name="sub_questions[${index}][text]"
                               value="${escapedText}"
                               placeholder="Masukkan label sub pertanyaan..."
                               required>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-check form-switch mb-2">
                                <input class="form-check-input" type="checkbox"
                                    name="sub_questions[${index}][is_required]" value="1"
                                    ${sub.is_required == 1 ? 'checked' : ''}>
                                <label class="form-check-label fw-medium text-dark">Wajib Diisi</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check form-switch mb-2">
                                <input class="form-check-input" type="checkbox"
                                    name="sub_questions[${index}][image_required_if_no]" value="1"
                                    ${sub.image_required_if_no == 1 ? 'checked' : ''}>
                                <label class="form-check-label fw-medium text-dark">Wajib Gambar jika "No"</label>
                            </div>
                        </div>
                    </div>
                </div>
                `;
            });
        } else {
            subQuestionsHtml = `
            <p class="text-muted text-center mb-0 py-3">
                <i class="fas fa-inbox me-1"></i> Belum ada sub pertanyaan
            </p>
            `;
        }

        html = `
        <div class="border border-primary-subtle p-3 rounded bg-light">
            <p class="small fw-medium text-primary mb-3">
                <i class="fas fa-list-ol me-1"></i> Sub Question List memungkinkan membuat daftar pertanyaan terkait.
            </p>

            <div class="mb-4">
                <label class="form-label small fw-medium text-secondary mb-2">Daftar Sub Pertanyaan:</label>
                <div id="editSubContainer_${questionId}" class="mb-3">
                    ${subQuestionsHtml}
                </div>

                <button type="button" class="btn btn-sm btn-primary w-100 mb-4"
                    onclick="addEditSubQuestion(${questionId})">
                    <i class="fas fa-plus me-1"></i> Tambah Sub Pertanyaan
                </button>
            </div>
        </div>
        `;
    } else if (type === 'pageNote') {
        questionTextContainer.style.display = 'block';
        questionText.placeholder = 'Masukkan catatan atau instruksi...';

        html = `
        <div class="border border-info-subtle p-3 rounded bg-light">
            <p class="small fw-medium text-info mb-3">
                <i class="fas fa-sticky-note me-1"></i> Tipe Page Note untuk menampilkan catatan atau instruksi di halaman.
            </p>
            <div class="form-check form-switch mb-2">
                <input class="form-check-input" type="checkbox" name="is_required" value="0" disabled>
                <label class="form-check-label fw-medium text-secondary">Catatan halaman</label>
                <small class="text-muted d-block">Hanya untuk informasi, tidak memerlukan jawaban</small>
            </div>
        </div>
        `;
    } else if (type === 'imageUpload') {
        questionTextContainer.style.display = 'block';
        questionText.placeholder = 'Masukkan instruksi upload gambar...';

        html = `
        <div class="border border-primary-subtle p-3 rounded bg-light">
            <p class="small fw-medium text-primary mb-3">
                <i class="fas fa-cloud-upload-alt me-1"></i> Tipe Image Upload untuk unggah gambar.
            </p>
            <div class="form-check form-switch mb-3">
                <input class="form-check-input" type="checkbox" name="is_required" value="1"
                    ${questionData.is_required ? 'checked' : ''}>
                <label class="form-check-label fw-medium text-dark">Wajib diisi</label>
                <small class="text-muted d-block">Upload gambar harus diisi</small>
            </div>
        </div>
        `;
    }

    dynamic.innerHTML = html;
    setupEditCommentToggle(questionId);
}

// Fungsi untuk Sub Question List di Edit
function addEditSubQuestion(questionId) {
    const container = document.getElementById('editSubContainer_' + questionId);
    if (!container) return;

    const subItems = container.querySelectorAll('.sub-question-item');
    const index = subItems.length;

    if (container.innerText.includes('Belum ada')) {
        container.innerHTML = '';
    }

    const html = `
    <div class="sub-question-item mb-4 p-3 border border-primary-subtle rounded bg-white">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h6 class="mb-0 text-primary">Sub Pertanyaan ${index + 1}</h6>
            <button type="button" class="btn btn-outline-danger btn-sm"
                onclick="this.closest('.sub-question-item').remove(); updateEditSubQuestionNumbers(${questionId})">
                <i class="fas fa-times"></i> Hapus
            </button>
        </div>

        <div class="mb-3">
            <label class="form-label small fw-medium text-secondary">Label *</label>
            <input type="text"
                   class="form-control border-primary-subtle"
                   name="sub_questions[${index}][text]"
                   placeholder="Masukkan label sub pertanyaan..."
                   required>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox"
                        name="sub_questions[${index}][is_required]" value="1" checked>
                    <label class="form-check-label fw-medium text-dark">Wajib Diisi</label>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox"
                        name="sub_questions[${index}][image_required_if_no]" value="1">
                    <label class="form-check-label fw-medium text-dark">Wajib Gambar jika "No"</label>
                </div>
            </div>
        </div>
    </div>
    `;

    container.insertAdjacentHTML('beforeend', html);
}

function updateEditSubQuestionNumbers(questionId) {
    const container = document.getElementById('editSubContainer_' + questionId);
    if (!container) return;

    const subItems = container.querySelectorAll('.sub-question-item');

    if (subItems.length === 0) {
        container.innerHTML = `
            <p class="text-muted text-center mb-0 py-3">
                <i class="fas fa-inbox me-1"></i> Belum ada sub pertanyaan
            </p>
        `;
        return;
    }

    subItems.forEach((item, index) => {
        const title = item.querySelector('h6');
        if (title) title.textContent = `Sub Pertanyaan ${index + 1}`;

        const inputs = item.querySelectorAll('input[name]');
        inputs.forEach(input => {
            input.name = input.name.replace(/sub_questions\[\d+\]/, `sub_questions[${index}]`);
        });
    });
}

function setupEditCommentToggle(questionId) {
    const hasCommentCheckbox = document.querySelector('.edit-has-comment[data-question="' + questionId + '"]');
    const commentRequiredCheckbox = document.querySelector('.edit-comment-child[data-question="' + questionId + '"]');

    if (hasCommentCheckbox && commentRequiredCheckbox) {
        commentRequiredCheckbox.disabled = !hasCommentCheckbox.checked;

        hasCommentCheckbox.addEventListener('change', function(e) {
            commentRequiredCheckbox.disabled = !e.target.checked;
            if (!e.target.checked) {
                commentRequiredCheckbox.checked = false;
            }
        });
    }
}
</script>
