<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sub_question_answers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('checklist_submission_id')->constrained()->cascadeOnDelete();
            $table->foreignId('sub_question_id')->constrained()->cascadeOnDelete();
            $table->string('room_number')->nullable();
            $table->enum('answer_yes_no', ['yes', 'no', 'good', 'bad' ])->nullable();
            $table->text('comment')->nullable();
            $table->string('image_path')->nullable();

            $table->timestamps();

            $table->unique(['checklist_submission_id', 'sub_question_id']);
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sub_question_answers');
    }
};
