<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('checklist_submissions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('checklist_id')->constrained()->cascadeOnDelete();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->foreignId('mod_session_id')->nullable()->constrained('mod_sessions')->nullOnDelete();
            $table->date('submitted_at');
            $table->enum('status', ['draft', 'submitted'])->default('draft');
            $table->text('overall_comment')->nullable();

            $table->timestamps();

            $table->unique(['checklist_id', 'user_id', 'submitted_at']);
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('checklist_submissions');
    }
};
