<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('schedule', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('month');
            $table->integer('year');
            $table->json('events');
            $table->string('image_path')->nullable();
            $table->boolean('is_active')->default(true); 
            $table->timestamps();
        });

        // Index untuk query cepat
        Schema::table('schedule', function (Blueprint $table) {
            $table->index(['year', 'month']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('schedules');
    }
};
