<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ModSession extends Model
{
    protected $fillable = [
        'user_id',
        'hotel',
        'event_date',
        'general_completed',
        'room_inspection_completed',
        'room_inspection_count',
        'signature_path',
        'submitted_at',
        'status',
    ];

    protected $casts = [
        'event_date' => 'date',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function submissions()
    {
        return $this->hasMany(ChecklistSubmission::class);
    }

    public function canAccessGeneral(): bool
    {
        return $this->status !== 'completed';
    }

    public function canAccessRoomInspection(): bool
    {
        return $this->general_completed && $this->room_inspection_count < 5;
    }

    public function canSign(): bool
    {
        return $this->general_completed && $this->room_inspection_completed;
    }

    public function markGeneralCompleted()
    {
        $this->general_completed = true;
        if ($this->room_inspection_completed) {
            $this->status = 'completed';
        } else {
            $this->status = 'in_progress';
        }
        $this->save();
    }

    public function incrementRoomInspection()
    {
        $this->room_inspection_count += 1;
        if ($this->room_inspection_count >= 5) {
            $this->room_inspection_completed = true;
        }
        if ($this->general_completed && $this->room_inspection_completed) {
            $this->status = 'completed';
        } else {
            $this->status = 'in_progress';
        }
        $this->save();
    }
}
